% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show_sig_fit.R
\name{show_sig_fit}
\alias{show_sig_fit}
\title{Show Signature Fit Result}
\usage{
show_sig_fit(
  fit_result,
  samples = NULL,
  signatures = NULL,
  plot_fun = c("boxplot", "violin", "scatter"),
  palette = "aaas",
  title = NULL,
  xlab = FALSE,
  ylab = "Signature exposure",
  legend = "none",
  width = 0.3,
  outlier.shape = NA,
  add = "jitter",
  add.params = list(alpha = 0.3),
  ...
)
}
\arguments{
\item{fit_result}{result object from \link{sig_fit}.}

\item{samples}{samples to show, if \code{NULL}, all samples are used.}

\item{signatures}{signatures to show.}

\item{plot_fun}{set the plot function.}

\item{palette}{the color palette to be used for coloring or filling by groups.
Allowed values include "grey" for grey color palettes; brewer palettes e.g.
"RdBu", "Blues", ...; or custom color palette e.g. c("blue", "red"); and
scientific journal palettes from ggsci R package, e.g.: "npg", "aaas",
"lancet", "jco", "ucscgb", "uchicago", "simpsons" and "rickandmorty".}

\item{title}{plot main title.}

\item{xlab}{character vector specifying x axis labels. Use xlab = FALSE to
hide xlab.}

\item{ylab}{character vector specifying y axis labels. Use ylab = FALSE to
hide ylab.}

\item{legend}{character specifying legend position. Allowed values are one of
c("top", "bottom", "left", "right", "none"). To remove the legend use
legend = "none". Legend position can be also specified using a numeric
vector c(x, y); see details section.}

\item{width}{numeric value between 0 and 1 specifying box width.}

\item{outlier.shape}{point shape of outlier. Default is 19. To hide outlier,
specify \code{outlier.shape = NA}. When jitter is added, then outliers will
be automatically hidden.}

\item{add}{character vector for adding another plot element (e.g.: dot plot or
error bars). Allowed values are one or the combination of: "none",
"dotplot", "jitter", "boxplot", "point", "mean", "mean_se", "mean_sd",
"mean_ci", "mean_range", "median", "median_iqr", "median_hilow",
"median_q1q3", "median_mad", "median_range"; see ?desc_statby for more
details.}

\item{add.params}{parameters (color, shape, size, fill, linetype) for the
argument 'add'; e.g.: add.params = list(color = "red").}

\item{...}{other arguments to be passed to
\code{\link[ggplot2]{geom_boxplot}}, \code{\link[ggpubr]{ggpar}} and
\code{\link[ggpubr]{facet}}.}
}
\value{
a \code{ggplot} object.
}
\description{
See \link{sig_fit} for examples.
}
\seealso{
\link{sig_fit}, \link{show_sig_bootstrap_exposure}, \link{sig_fit_bootstrap}, \link{sig_fit_bootstrap_batch}
}
