% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recombination.R
\name{getCMfromBP}
\alias{getCMfromBP}
\title{Converts centimorgan position to base-pair. Return a list of centimorgan positions that correspond
to the bp vector (in basepairs).}
\usage{
getCMfromBP(bp)
}
\arguments{
\item{bp}{vector of base-pair positions}
}
\description{
Converts centimorgan position to base-pair. Return a list of centimorgan positions that correspond
to the bp vector (in basepairs).
}
\examples{

library("sim1000G")

examples_dir = system.file("examples", package = "sim1000G")
vcf_file = sprintf("\%s/region.vcf.gz", examples_dir)
vcf = readVCF( vcf_file, maxNumberOfVariants = 100 , min_maf = 0.12 ,max_maf = NA)

# For realistic data use the functions downloadGeneticMap / readGeneticMap
generateUniformGeneticMap()
getCMfromBP(seq(1e6,100e6,by=1e6))


}
