% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_offspring.R
\name{sample_offspring}
\alias{sample_offspring}
\title{Sample offspring from two parental genotypes}
\usage{
sample_offspring(father, mother, label = "Child")
}
\arguments{
\item{father}{DataFrame (see \link{sample_genotype})}

\item{mother}{DataFrame (see \link{sample_genotype})}

\item{label}{SampleName of child (character)}
}
\value{
DataFrame (see \link{sample_genotype})
}
\description{
Sample offspring from two parental genotypes
}
\details{
A genotype is sampled according to Mendelian inheritance. That is, one of two alleles of a parent is passed down to the offspring.
}
\examples{
# below we read an allele freqs and sample a genotype
filename <- system.file("extdata","FBI_extended_Cauc.csv",
                        package = "simDNAmixtures")
freqs <- read_allele_freqs(filename)

# sample parents
father <- sample_genotype(freqs, loci = c("D3S1358", "vWA"))
mother <- sample_genotype(freqs, loci = c("D3S1358", "vWA"))

# sample child
child <- sample_offspring(father, mother)
}
