% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_meteorlogy.R
\name{cal_solarInclination}
\alias{cal_solarInclination}
\title{Calculating solar inclination}
\usage{
cal_solarInclination(solar_declination, latitude, hour_anger)
}
\arguments{
\item{solar_declination}{is solar declination anger. It can be calculated from cal_solardeclination().}

\item{latitude}{is the latitude data (Radian).}

\item{hour_anger}{is hour anger. It can be calculated from cal_hourangle().}
}
\value{
A vector for solar inclination (Radian)
}
\description{
A parameter used to determine the position of the sun relative
  to the observer (the other one is the angle from south).Conversion
  relationship with solar altitude angle:
  solar inclination=pi/2-solar altitude.
}
\examples{
cal_solarInclination(solar_declination=-0.297,latitude=30,hour_anger=0)
}
\references{
Teh CBS.Introduction to mathematical modeling of crop growth:
           How the equations are derived and assembled into a computer model.
           Brown Walker Press, 2006.
}
