\name{vnorm}
\alias{vnorm}
\alias{Normal}

\title{Variate Generator for the Normal Distribution}
\description{
  Generates random variates from the normal distribution, with options for
  independent streams and antithetic variates.
}
\usage{
  vnorm(n, mean = 0, sd = 1, stream = NULL, antithetic = FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n     }{number of observations}
  \item{mean  }{mean of the distribution}
  \item{sd    }{standard deviation of the distribution}
  \item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
    to generate uniform variates to invert via \code{\link[=qnorm]{stats::qnorm}}; 
    otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
    from which to generate uniform variates to invert via
    \code{\link[=qnorm]{stats::qnorm}}}
  \item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
    variate(s) generated via either \code{\link[=runif]{stats::runif}} or
    \code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
    \eqn{1 - u}}
}
\details{
  Generates random variates from the normal distribution.

  Normal variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}} (if
  \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qnorm]{stats::qnorm}} is used to invert the
  uniform(0,1) variate(s).
  In this way, using \code{vnorm} provides a monotone and synchronized
  normal variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

  If \code{mean} or \code{sd} are not specified, they assume the default values
  of 0 and 1, respectively.

  The normal distribution has density

      \deqn{f(x) = \frac{1}{\sqrt{2\pi}\sigma} e^{-(x - \mu)^2/(2 \sigma^2)}}{%
            f(x) = 1/(\sqrt(2\pi)\sigma) e^(-(x - \mu)^2/(2 \sigma^2))}

  for \eqn{-\infty < x < \infty} and \eqn{\sigma > 0}, where \eqn{\mu} is the
  mean of the distribution and \eqn{\sigma} the standard deviation.
}
\value{
  A vector of normal random variates 
}
\seealso{
    \code{\link[=rnorm]{stats::rnorm}}, \code{\link[=runif]{stats::runif}},
    \code{\link{rstream}}, \code{\link{set.seed}}
}
\author{Barry Lawson (\email{blawson@richmond.edu}), 
        Larry Leemis (\email{leemis@math.wm.edu})}
\examples{
set.seed(8675309)
vnorm(3)  # generate standard normals: inverts stats::runif using stats::qnorm

set.seed(8675309)
vnorm(3, mean = 2, sd = 1)  # inverts stats::runif using stats::qnorm

set.seed(8675309)
vnorm(3, mean = 2, sd = 1, stream = 1) # inverts rstream::rstream.sample using stats::qnorm
vnorm(3, mean = 2, sd = 1, stream = 2)

set.seed(8675309)
vnorm(1, mean = 2, sd = 1, stream = 1) # inverts rstream::rstream.sample using stats::qnorm
vnorm(1, mean = 2, sd = 1, stream = 2)
vnorm(1, mean = 2, sd = 1, stream = 1)
vnorm(1, mean = 2, sd = 1, stream = 2)
vnorm(1, mean = 2, sd = 1, stream = 1)
vnorm(1, mean = 2, sd = 1, stream = 2)

set.seed(8675309)
variates <- vnorm(1000, mean = 10, sd = 2, stream = 1)
set.seed(8675309)
variates <- vnorm(1000, mean = 10, sd = 2, stream = 1, antithetic = TRUE)
}
\keyword{distribution}  % RShowDoc("KEYWORDS") for suggested list
\concept{random variate generation}
