% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generators.R
\name{vweibull}
\alias{vweibull}
\title{Variate Generation for Weibull Distribution}
\usage{
vweibull(
  n,
  shape,
  scale = 1,
  stream = NULL,
  antithetic = FALSE,
  asList = FALSE
)
}
\arguments{
\item{n}{number of observations}

\item{shape}{Shape parameter}

\item{scale}{Scale parameter (default 1)}

\item{stream}{if \code{NULL} (default), uses \code{\link[=runif]{stats::runif}}
to generate uniform variates to invert via 
\code{\link[=qweibull]{stats::qweibull}};
otherwise, an integer in 1:25 indicates the \code{\link{rstream}} stream
from which to generate uniform variates to invert via
\code{\link[=qweibull]{stats::qweibull}};}

\item{antithetic}{if \code{FALSE} (default), inverts \eqn{u} = uniform(0,1)
variate(s) generated via either \code{\link[=runif]{stats::runif}} or
\code{\link[=rstream.sample]{rstream::rstream.sample}}; otherwise, uses
\eqn{1 - u}}

\item{asList}{if \code{FALSE} (default), output only the generated
random variates; otherwise, return a list with components suitable for
visualizing inversion. See return for details}
}
\value{
If \code{asList} is FALSE (default), return a vector of random variates.

  Otherwise, return a list with components suitable for visualizing inversion,
  specifically:
    \item{u}{        A vector of generated U(0,1) variates }
    \item{x}{        A vector of Weibull random variates }
    \item{quantile}{ Parameterized quantile function }
    \item{text}{     Parameterized title of distribution }
}
\description{
Variate Generation for Weibull Distribution
}
\details{
Generates random variates from the Weibull distribution.

  Weibull variates are generated by inverting uniform(0,1) variates
  produced either by \code{\link[=runif]{stats::runif}} (if \code{stream} is
  \code{NULL}) or by \code{\link[=rstream.sample]{rstream::rstream.sample}}
  (if \code{stream} is not \code{NULL}).
  In either case, \code{\link[=qweibull]{stats::qweibull}} is used to
  invert the uniform(0,1) variate(s).
  In this way, using \code{vweibull} provides a monotone and synchronized
  binomial variate generator, although not particularly fast.

  The stream indicated must be an integer between 1 and 25 inclusive.

The Weibull distribution with parameters \code{shape} = \eqn{a} and
 \code{scale} = \eqn{b} has density

     \deqn{f(x) = \frac{a}{b} \left(\frac{x}{b}\right)^{a-1} e^{-(x/b)^a}}{%
           f(x) = (a/b) (x/b)^(a-1) exp(-(x/b)^a)}

  for \eqn{x \ge 0}, \eqn{a > 0}, and \eqn{b > 0}.
}
\examples{
 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qweibull
 vweibull(3, shape = 2, scale = 1)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qweibull
 vweibull(3, 2, 1, stream = 1)
 vweibull(3, 2, 1, stream = 2)

 set.seed(8675309)
 # NOTE: following inverts rstream::rstream.sample using stats::qweibull
 vweibull(1, 2, 1, stream = 1)
 vweibull(1, 2, 1, stream = 2)
 vweibull(1, 2, 1, stream = 1)
 vweibull(1, 2, 1, stream = 2)
 vweibull(1, 2, 1, stream = 1)
 vweibull(1, 2, 1, stream = 2)

 set.seed(8675309)
 variates <- vweibull(1000, 2, 1, stream = 1)
 set.seed(8675309)
 variates <- vweibull(1000, 2, 1, stream = 1, antithetic = TRUE)

}
\seealso{
\code{\link{rstream}}, \code{\link{set.seed}},
         \code{\link[=runif]{stats::runif}}

\code{\link[=rweibull]{stats::rweibull}}
}
\author{
Barry Lawson (\email{blawson@richmond.edu}), \cr
   Larry Leemis (\email{leemis@math.wm.edu}), \cr
   Vadim Kudlay (\email{vadim.kudlay@richmond.edu})
}
\concept{random variate generation}
\keyword{distribution}
