% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survivalFunctions.R
\name{integrateVector}
\alias{integrateVector}
\title{Helper for Efficient Integration}
\usage{
integrateVector(integrand, upper, ...)
}
\arguments{
\item{integrand}{(\code{function})\cr  to be integrated.}

\item{upper}{(\code{numeric})\cr upper limits of integration.}

\item{...}{additional arguments to be passed to \code{integrand}.}
}
\value{
This function returns for each upper limit the estimates of the integral.
}
\description{
Helper for Efficient Integration
}
\examples{
integrand <- function(x) x^2
upper <- c(0, 1, 0.4, 2, 5, 2, 0.3, 0.4, 1)
integrateVector(integrand, upper = upper)
}
