% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.r
\name{DF.to.long}
\alias{DF.to.long}
\title{Convert Data from Wide to Long Format Using \code{reshape}}
\usage{
DF.to.long(df_wide)
}
\arguments{
\item{df_wide}{A \code{data.frame} in wide format}
}
\value{
A \code{data.frame} object in long format
}
\description{
This utility function takes a simulated data.frame in wide format as an input and converts it into a long format (slower compared to \code{\link{DF.to.longDT}}).
}
\details{
Keeps all covariates that appear only once and at the first time-point constant (carry-forward).

All covariates that appear fewer than range(t) times are imputed with NA for missing time-points.

Observations with all NA's for all time-varying covariates are removed.

When removing NA's the time-varying covariates that are attributes (attnames) are not considered.
}
\seealso{
\code{\link{DF.to.longDT}} - a faster version of \code{DF.to.long} that uses \code{data.table} package

Other data manipulation functions: \code{\link{DF.to.longDT}},
  \code{\link{doLTCF}}
}
\concept{data manipulation functions}
