# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Simulate Binary Responses for a DINA Model
#'
#' Generate the dichotomous item matrix for a DINA Model.
#'
#' @param N     Number of Observations
#' @param J     Number of Assessment Items
#' @param CLASS Does the individual possess all the necessary attributes?
#' @param ETA   \eqn{\eta} Matrix containing indicators.
#' @param gs    A `vec` describing the probability of guessing or
#'              the probability subject correctly answers item \eqn{j} when at
#'              least one attribute is lacking.
#' @param ss    A `vec` describing the probability of slipping or
#'              the probability of an incorrect response for individuals with
#'              all of the required attributes
#'
#' @return
#' A dichotomous item matrix with dimensions \eqn{N \times J}{N x J}.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::sim_dina_attributes()] and [simcdm::sim_dina_items()]
#'
#' @export
#' @template sim-dina-class-example
sim_dina_class <- function(N, J, CLASS, ETA, gs, ss) {
    .Call(`_simcdm_sim_dina_class`, N, J, CLASS, ETA, gs, ss)
}

#' Simulate a DINA Model's \eqn{\eta} Matrix
#'
#' Generates a DINA model's \eqn{\eta} matrix based on alphas and
#' the \eqn{\mathbf{Q}} matrix.
#'
#' @inheritParams sim_dina_items
#'
#' @return
#' The \eqn{\eta} `matrix` with dimensions \eqn{N \times J}{N x J} under
#' the DINA model.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::sim_dina_class()] and [simcdm::sim_dina_items()]
#'
#' @export
#' @template sim-dina-example-body
sim_dina_attributes <- function(alphas, Q) {
    .Call(`_simcdm_sim_dina_attributes`, alphas, Q)
}

#' Simulation Responses from the DINA model
#'
#' Sample responses from the DINA model for given attribute profiles, Q matrix,
#' and item parmeters. Returns a `matrix` of dichotomous responses
#' generated under DINA model.
#'
#' @param alphas A \eqn{N} by \eqn{K} `matrix` of latent attributes.
#' @param Q      A \eqn{J} by \eqn{K} `matrix` indicating which skills are
#'               required for which items.
#' @param ss     A \eqn{J} `vector` of item slipping parameters. 
#' @param gs     A \eqn{J} `vector` of item guessing parameters.
#'
#' @return
#' A \eqn{N} by \eqn{J} `matrix` of responses from the DINA model.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::sim_dina_class()] and [simcdm::sim_dina_attributes()]
#'
#' @export
#' @template sim-dina-example-body
sim_dina_items <- function(alphas, Q, ss, gs) {
    .Call(`_simcdm_sim_dina_items`, alphas, Q, ss, gs)
}

sim_rrum_main <- function(Q, rstar, pistar, alpha) {
    .Call(`_simcdm_sim_rrum_main`, Q, rstar, pistar, alpha)
}

#' Generate data from the rRUM
#'
#' Randomly generate response data according to the reduced Reparameterized
#' Unified Model (rRUM).
#'
#' @param Q      A `matrix` with \eqn{J} rows and \eqn{K} columns indicating
#'               which attributes are required to answer each of the items,
#'               where \eqn{J} represents the number of items and \eqn{K} the
#'               number of attributes.  An entry of 1 indicates attribute
#'               \eqn{k} is required to answer item \eqn{j}.  An entry of one
#'               indicates attribute \eqn{k} is not required.
#' @param rstar  A `matrix` a matrix with \eqn{J} rows and \eqn{K} columns
#'               indicating the penalties for failing to have each of the
#'               required attributes, where \eqn{J} represents the number of
#'               items and \eqn{K} the number of attributes. `rstar` and `Q`
#'               must share the same 0 entries.
#' @param pistar A `vector` of length \eqn{J} indicating the probabiliies of
#'               answering each item correctly for individuals who do not lack
#'               any required attribute, where \eqn{J} represents the number
#'               of items.
#' @param alpha  A `matrix` with \eqn{N} rows and \eqn{K} columns indicating
#'               the subjects attribute acquisition, where \eqn{K} represents
#'               the number of attributes.  An entry of 1 indicates individual
#'               \eqn{i} has attained attribute \eqn{k}. An entry of 0
#'               indicates the attribute has not been attained.
#' @return Y     A `matrix` with \eqn{N} rows and \eqn{J} columns indicating
#'               the indviduals' responses to each of the items, where \eqn{J}
#'               represents the number of items.
#' @author
#' Steven Andrew Culpepper, Aaron Hudson, and James Joseph Balamuta
#'
#' @export
#' @template rrum-example
#' @template rrum-references
sim_rrum_items <- function(Q, rstar, pistar, alpha) {
    .Call(`_simcdm_sim_rrum_items`, Q, rstar, pistar, alpha)
}

#' Constructs Unique Attribute Pattern Map
#'
#' Computes the powers of 2 from \eqn{0} up to \eqn{K - 1} for
#' \eqn{K}-dimensional attribute pattern.
#'
#' @param K  Number of Attributes.
#'
#' @return
#' A \code{vec} with length \eqn{K} detailing the power's of 2.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::attribute_inv_bijection()]
#'
#' @export
#' @examples
#' ## Construct an attribute bijection ----
#' biject = attribute_bijection(3)
attribute_bijection <- function(K) {
    .Call(`_simcdm_attribute_bijection`, K)
}

#' Perform an Inverse Bijection of an Integer to Attribute Pattern
#'
#' Convert an integer between \eqn{0} and \eqn{2^{K-1}} to
#' \eqn{K}-dimensional attribute pattern.
#'
#' @param CL An `integer` between \eqn{0} and \eqn{2^{K-1}}
#' @inheritParams attribute_bijection
#'
#' @return
#' A \eqn{K}-dimensional vector with an attribute pattern corresponding
#' to `CL`.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::attribute_bijection()]
#'
#' @export
#' @examples
#' ## Construct an attribute inversion bijection ----
#' inv_biject1 = attribute_inv_bijection(5, 1)
#' inv_biject2 = attribute_inv_bijection(5, 2)
attribute_inv_bijection <- function(K, CL) {
    .Call(`_simcdm_attribute_inv_bijection`, K, CL)
}

#' Generate a Random Identifiable Q Matrix
#'
#' Simulates a Q matrix containing three identity matrices after a row
#' permutation that is identifiable.
#'
#' @param J Number of Items
#' @param K Number of Attributes
#'
#' @return
#' A dichotomous \code{matrix} for Q.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::attribute_bijection()] and [simcdm::attribute_inv_bijection()]
#'
#' @export
#' @examples
#' ## Simulate identifiable Q matrices ----
#'
#' # 7 items and 2 attributes
#' q_matrix_j7_k2 = sim_q_matrix(7, 2)
#'
#' # 10 items and 3 attributes
#' q_matrix_j10_k3 = sim_q_matrix(10, 3)
sim_q_matrix <- function(J, K) {
    .Call(`_simcdm_sim_q_matrix`, J, K)
}

#' Generate ideal response \eqn{\eta} Matrix
#'
#' Creates the ideal response matrix for each trait
#'
#' @param K      Number of Attribute Levels
#' @param J      Number of Assessment Items
#' @param Q      Q Matrix with dimensions \eqn{K \times J}{K x J}.
#'
#' @return
#' A `mat` with dimensions \eqn{J \times 2^K}{J x 2^K}.
#'
#' @author
#' Steven Andrew Culpepper and James Joseph Balamuta
#'
#' @seealso
#' [simcdm::sim_q_matrix()], [simcdm::attribute_bijection()], and
#' [simcdm::attribute_inv_bijection()]
#'
#' @export
#' @examples
#' ## Simulation Settings ----
#'
#' # Fixed Number of Assessment Items for Q
#' J = 18
#'
#' # Fixed Number of Attributes for Q
#' K = 3
#'
#' ## Pre-specified configuration ----
#'
#' # Specify Q
#' qbj = c(4, 2, 1, 4, 2, 1, 4, 2, 1, 6, 5, 3, 6, 5, 3, 7, 7, 7)
#'
#' # Fill Q Matrix
#' Q = matrix(, J, K)
#' for (j in seq_len(J)) {
#'   Q[j,] = attribute_inv_bijection(K, qbj[j])
#' }
#'
#' # Create an eta matrix
#' ETA = sim_eta_matrix(K, J, Q)
#'
#' ## Random generation of Q matrix with ETA matrix ----
#'
#' # Construct a random q matrix
#' Q_sim = sim_q_matrix(J, K)
#'
#' # Generate the eta matrix
#' ETA_gen = sim_eta_matrix(K, J, Q_sim)
sim_eta_matrix <- function(K, J, Q) {
    .Call(`_simcdm_sim_eta_matrix`, K, J, Q)
}

#' Simulate all the Latent Attribute Profile \eqn{\mathbf{\alpha}_c} in
#' Matrix form
#'
#' Generate the \eqn{\mathbf{\alpha}_c = (\alpha_{c1}, \ldots, \alpha_{cK})'}
#' attribute profile matrix for members of class \eqn{c} such that 
#' \eqn{\alpha_{ck}} ' is 1 if members of class \eqn{c} possess skill \eqn{k}
#' and zero otherwise.
#'
#' @param K Number of Attributes
#'
#' @return
#' A \eqn{2^K} by \eqn{K} `matrix` of latent classes
#' corresponding to entry \eqn{c} of \eqn{pi} based upon
#' mastery and nonmastery of the \eqn{K} skills.
#'
#' @author
#' James Joseph Balamuta and Steven Andrew Culpepper
#'
#' @seealso
#' [simcdm::sim_subject_attributes()] and [simcdm::attribute_inv_bijection()]
#'
#' @export
#' @examples
#' ## Simulate Attribute Class Matrix ----
#'
#' # Define number of attributes
#' K = 3
#'
#' # Generate an Latent Attribute Profile (Alpha) Matrix
#' alphas = attribute_classes(K)
attribute_classes <- function(K) {
    .Call(`_simcdm_attribute_classes`, K)
}

#' Simulate Subject Latent Attribute Profiles \eqn{\mathbf{\alpha}_c}
#'
#' Generate a sample from the
#'  \eqn{\mathbf{\alpha}_c = (\alpha_{c1}, \ldots, \alpha_{cK})'}
#' attribute profile matrix for members of class \eqn{c} such that
#' \eqn{\alpha_{ck}} ' is 1 if members of class \eqn{c} possess skill \eqn{k} 
#' and zero otherwise.
#'
#' @param N      Number of Observations
#' @param K      Number of Skills
#' @param probs  A `vector` of probabilities that sum to 1.
#'
#' @return
#' A \eqn{N} by \eqn{K} `matrix` of latent classes
#' corresponding to entry \eqn{c} of \eqn{pi} based upon
#' mastery and nonmastery of the \eqn{K} skills.
#'
#' @author
#' James Joseph Balamuta and Steven Andrew Culpepper
#'
#' @seealso
#' [simcdm::attribute_classes()] and [simcdm::attribute_inv_bijection()]
#'
#' @export
#' @examples
#' # Define number of subjects and attributes
#' N = 100
#' K = 3
#'
#' # Generate a sample from the Latent Attribute Profile (Alpha) Matrix
#' # By default, we sample from a uniform distribution weighting of classes.
#' alphas_builtin = sim_subject_attributes(N, K)
#'
#' # Generate a sample using custom probabilities from the
#' # Latent Attribute Profile (Alpha) Matrix
#' probs = rep(1 / (2 ^ K), 2 ^ K)
#' alphas_custom = sim_subject_attributes(N, K, probs)
sim_subject_attributes <- function(N, K, probs = NULL) {
    .Call(`_simcdm_sim_subject_attributes`, N, K, probs)
}

# Register entry points for exported C++ functions
methods::setLoadAction(function(ns) {
    .Call('_simcdm_RcppExport_registerCCallable', PACKAGE = 'simcdm')
})
