% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_ail_pedigree_fix_n.R
\name{sim_ail_pedigree_fix_n}
\alias{sim_ail_pedigree_fix_n}
\title{Simulate AIL pedigree with fixed n}
\usage{
sim_ail_pedigree_fix_n(
  ngen = 12,
  nkids_per = 5,
  nsample_ngen = 150,
  npairs = NULL,
  method = c("last2", "sub2"),
  design = c("nosib", "random")
)
}
\arguments{
\item{ngen}{Number of generations of outbreeding}

\item{nkids_per}{Number of offspring per pair for the last
generation}

\item{nsample_ngen}{Number of individuals desired at the last
generation}

\item{npairs}{Number of breeding pairs at each generation. If
missing, we use 30 when \code{method="last2"} and 300 when
\code{method="sub2"}.}

\item{method}{Method used to generate pedigree: either expand at the last
two generations or generate a pedigree with a large number of pairs and
select a subset to have the desired sample size.}

\item{design}{How to choose crosses: either random but avoiding
siblings, or completely at random}
}
\value{
A data frame with five columns: individual ID, mother ID,
father ID, sex, and generation.  Founders have \code{0} for mother
and father ID. Sex is coded 0 for female and 1 for male.
}
\description{
Simulate a pedigree for advanced intercross lines (a table of
individual, mom, dad, sex) so that the last generation reaches a
desired sample size n
}
\details{
The default value for \code{npairs} depends on the choice of \code{method}.
For \code{method="last2"}, we use a default of \code{npairs=30}; for
\code{method="sub2"}, we use a default of \code{npairs=300}.
}
\examples{
tab <- sim_ail_pedigree_fix_n(12)
}
\seealso{
\code{\link[=sim_from_pedigree]{sim_from_pedigree()}},
\code{\link[=sim_ril_pedigree]{sim_ril_pedigree()}}, \code{\link[=sim_ail_pedigree]{sim_ail_pedigree()}},
\code{\link[=sim_do_pedigree]{sim_do_pedigree()}}, \code{\link[=sim_4way_pedigree]{sim_4way_pedigree()}},
\code{\link[=sim_do_pedigree_fix_n]{sim_do_pedigree_fix_n()}}
}
\keyword{datagen}
