% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.Json}
\alias{simer.Data.Json}
\title{Data quality control}
\usage{
simer.Data.Json(
  jsonFile,
  out = "simer.qc",
  dataQC = TRUE,
  buildModel = TRUE,
  buildIndex = TRUE,
  ncpus = 10,
  verbose = TRUE
)
}
\arguments{
\item{jsonFile}{the path of JSON file.}

\item{out}{the prefix of output files.}

\item{dataQC}{whether to make data quality control.}

\item{buildModel}{whether to build EBV model.}

\item{buildIndex}{whether to build Selection Index.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$genotype}{the path of genotype data.}
\item{$pedigree}{the filename of pedigree data.}
\item{$selection_index}{the selection index for all traits.}
\item{$breeding_value_index}{the breeding value index for all traits.}
\item{$quality_control_plan}{a list of parameters for data quality control.}
\item{$analysis_plan}{a list of parameters for genetic evaluation.}
}
}
\description{
Make data quality control by JSON file.
}
\details{
Build date: Oct 19, 2020
Last update: Apr 28, 2022
}
\examples{
# Get JSON file
jsonFile <- system.file("extdata", "04breeding_plan", "plan1.json", package = "simer")

\dontrun{
# It needs 'plink' and 'hiblup' software
jsonList <- simer.Data.Json(jsonFile = jsonFile)
}
}
\author{
Dong Yin
}
