% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simer.Data.R
\name{simer.Data.SELIND}
\alias{simer.Data.SELIND}
\title{Selection index construction}
\usage{
simer.Data.SELIND(jsonList = NULL, hiblupPath = "", ncpus = 10, verbose = TRUE)
}
\arguments{
\item{jsonList}{the list of selection index construction parameters.}

\item{hiblupPath}{the path of HIBLUP software.}

\item{ncpus}{the number of threads used, if NULL, (logical core number - 1) is automatically used.}

\item{verbose}{whether to print detail.}
}
\value{
the function returns a list containing
\describe{
\item{$genotype}{the path of genotype data.}
\item{$pedigree}{the filename of pedigree data.}
\item{$selection_index}{the selection index for all traits.}
\item{$breeding_value_index}{the breeding value index for all traits.}
\item{$quality_control_plan}{a list of parameters for data quality control.}
\item{$breeding_plan}{a list of parameters for genetic evaluation.}
}
}
\description{
The function of General Selection Index.
}
\details{
Build date: Aug 26, 2021
Last update: Apr 28, 2022
}
\examples{
# Read JSON file
jsonFile <- system.file("extdata", "04breeding_plan", "plan1.json", package = "simer")
jsonList <- jsonlite::fromJSON(txt = jsonFile, simplifyVector = FALSE)

\dontrun{
# It needs 'hiblup' software
jsonList <- simer.Data.SELIND(jsonList = jsonList)
}
}
\references{
Y. S. Chen, Z. L. Sheng (1988) The Theory of General Selection Index. Genetic Report, 15(3): P185-P190
}
\author{
Dong Yin
}
