% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggplot_sf_fun.R
\name{ggplot_sf_col_facet}
\alias{ggplot_sf_col_facet}
\title{Map of simple features in ggplot that is coloured and facetted.}
\usage{
ggplot_sf_col_facet(data, col_var, facet_var, col_method = NULL,
  bin_cuts = NULL, quantile_cuts = c(0, 0.25, 0.5, 0.75, 1),
  quantile_by_facet = TRUE, size = 0.5, alpha = 0.9, pal = NULL,
  rev_pal = FALSE, col_scale_drop = FALSE, remove_na = FALSE,
  facet_nrow = NULL, legend_ncol = 3, legend_digits = 1,
  coastline = NULL, coastline_behind = TRUE,
  coastline_pal = "#7f7f7f", title = "[Title]", subtitle = NULL,
  col_title = "", caption = "", legend_labels = NULL,
  font_family = "Helvetica", font_size_title = NULL,
  font_size_body = NULL, wrap_title = 70, wrap_subtitle = 80,
  wrap_col_title = 25, wrap_caption = 80, isMobile = FALSE)
}
\arguments{
\item{data}{A sf object with defined coordinate reference system. Required input.}

\item{col_var}{Unquoted variable for points to be coloured by. Required input.}

\item{facet_var}{Unquoted categorical variable to facet the data by. Required input.}

\item{col_method}{The method of colouring features, either "bin", "quantile" or "category." NULL results in "category", if categorical or "quantile" if numeric col_var. Note all numeric variables are cut to be inclusive of the min in the range, and exclusive of the max in the range (except for the final bucket which includes the highest value).}

\item{bin_cuts}{A vector of bin cuts applicable where col_method of "bin" is selected. The first number in the vector should be either -Inf or 0, and the final number Inf. If NULL, 'pretty' breaks are used.}

\item{quantile_cuts}{A vector of probability cuts applicable where col_method of "quantile" is selected. The first number in the vector should 0 and the final number 1. Defaults to quartiles. Only applicable where col_method equals "quantile".}

\item{quantile_by_facet}{TRUE of FALSE  whether quantiles should be calculated for each group of the facet variable. Defaults to TRUE.}

\item{size}{Size of points. Defaults to 0.5.}

\item{alpha}{The opacity of polygons. Defaults to 0.9.}

\item{pal}{Character vector of hex codes. Defaults to NULL, which selects the colorbrewer Set1 or viridis.}

\item{rev_pal}{Reverses the palette. Defaults to FALSE.}

\item{col_scale_drop}{TRUE or FALSE  of whether to drop unused levels from the legend. Defaults to FALSE.}

\item{remove_na}{TRUE or FALSE  of whether to remove NAs of the colour variable. Defaults to FALSE.}

\item{facet_nrow}{The number of rows of facetted plots. Not applicable to where isMobile is TRUE.}

\item{legend_ncol}{The number of columns in the legend.}

\item{legend_digits}{Select the appropriate number of decimal places for numeric variable auto legend labels. Defaults to 1.}

\item{coastline}{Add a sf object as a coastline (or administrative boundaries). Defaults to NULL. Use nz (or nz_region) to add a new zealand coastline. Or add a custom sf object.}

\item{coastline_behind}{TRUE or FALSE  as to whether the coastline is to be behind the sf object defined in the data argument. Defaults to FALSE.}

\item{coastline_pal}{Colour of the coastline. Defaults to "#7F7F7F".}

\item{title}{Title string. Defaults to "[Title]".}

\item{subtitle}{Subtitle string. Defaults to "[Subtitle]".}

\item{col_title}{Colour title string for the legend. Defaults to NULL.}

\item{caption}{Caption title string. Defaults to NULL.}

\item{legend_labels}{A vector of manual legend label values. Defaults to NULL, which results in automatic labels.}

\item{font_family}{Font family to use. Defaults to "Helvetica".}

\item{font_size_title}{Font size for the title text. Defaults to 11.}

\item{font_size_body}{Font size for all text other than the title. Defaults to 10.}

\item{wrap_title}{Number of characters to wrap the title to. Defaults to 70. Not applicable where isMobile equals TRUE.}

\item{wrap_subtitle}{Number of characters to wrap the subtitle to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{wrap_col_title}{Number of characters to wrap the colour title to. Defaults to 25. Not applicable where isMobile equals TRUE.}

\item{wrap_caption}{Number of characters to wrap the caption to. Defaults to 80. Not applicable where isMobile equals TRUE.}

\item{isMobile}{Whether the plot is to be displayed on a mobile device. Defaults to FALSE. In a shiny app, use input$isMobile if your app is able to retreive this input. A method to do this is described at https://g3rv4.com/2017/08/shiny-detect-mobile-browsers}
}
\value{
A ggplot object.
}
\description{
Map of simple features in ggplot that is coloured and facetted.
}
\examples{
map_data <- example_sf_nz_river_wq \%>\%
 dplyr::filter(period == "1998-2017",
 indicator \%in\% c("Nitrate-nitrogen", "Dissolved reactive phosphorus"))
 
 pal <- c("#4575B4", "#D3D3D3", "#D73027")

ggplot_sf_col_facet(data = map_data, col_var = trend_category, facet_var = indicator,
 coastline = nz, pal = pal,
 title = "Monitored river nitrate-nitrogen trends, 2008-17")
}
