% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/leaf_stars.R
\name{leaf_stars}
\alias{leaf_stars}
\title{Stars leaflet map.}
\usage{
leaf_stars(
  data,
  pal = pal_viridis_reorder(1),
  alpha_fill = 0.5,
  basemap = "light",
  group_id = NULL,
  map_id = "map"
)
}
\arguments{
\item{data}{A stars object. Required input.}

\item{pal}{Character vector of hex codes.}

\item{alpha_fill}{The opacity of the fill. Defaults to 0.5.}

\item{basemap}{The underlying basemap. Either "light", "dark", "satellite", "street", or "ocean". Defaults to "light". Only applicable where shiny equals FALSE.}

\item{group_id}{The id name for the stars group.}

\item{map_id}{The map id for the leaflet map. Defaults to "map".}
}
\value{
A leaflet object.
}
\description{
Map of stars in leaflet that is not coloured.
}
\examples{
\dontrun{
library(simplevis)

leaf_stars(example_stars) 
}
  
}
