% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{add_composite_scores}
\alias{add_composite_scores}
\title{Add composite scores to observed data}
\usage{
add_composite_scores(d, m, ...)
}
\arguments{
\item{d}{A data.frame with observed data in standardized form (i.e, z-scores)}

\item{m}{A character string with lavaan model}

\item{...}{parameters passed to simstandardized_matrices}
}
\value{
data.frame with observed data and estimated factor scores
}
\description{
Add composite scores to observed data
}
\examples{
library(simstandard)
# lavaan model
m = "
X =~ 0.9 * X1 + 0.8 * X2 + 0.7 * X3
"

# Make data.frame for two cases
d <- data.frame(
  X1 = c(1.2, -1.2),
  X2 = c(1.5, -1.8),
  X3 = c(1.8, -1.1))

# Compute factor scores for two cases
add_composite_scores(d, m)
}
