% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{add_factor_scores}
\alias{add_factor_scores}
\title{Add factor scores to observed data}
\usage{
add_factor_scores(d, m, CI = FALSE, p = 0.95, ...)
}
\arguments{
\item{d}{A data.frame with observed data in standardized form (i.e, z-scores)}

\item{m}{A character string with lavaan model}

\item{CI}{Add confidence intervals? Defaults to `FALSE`. If `TRUE`, For each factor score, a lower and upper bound of the confidence interval is created. For example, the lower bound of factor score `X` is `X_LB`, and the upper bound is `X_UB`.}

\item{p}{confidence interval proportion. Defaults to 0.95}

\item{...}{parameters passed to simstandardized_matrices}
}
\value{
data.frame with observed data and estimated factor scores
}
\description{
Add factor scores to observed data
}
\examples{
library(simstandard)
# lavaan model
m = "
X =~ 0.9 * X1 + 0.8 * X2 + 0.7 * X3
"

# Make data.frame for two cases
d <- data.frame(
  X1 = c(1.2, -1.2),
  X2 = c(1.5, -1.8),
  X3 = c(1.8, -1.1))

# Compute factor scores for two cases
add_factor_scores(d, m)
}
