% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genMultiFac.R
\name{genMultiFac}
\alias{genMultiFac}
\title{Generate multi-factorial data}
\usage{
genMultiFac(
  nFactors,
  each,
  levels = 2,
  coding = "dummy",
  colNames = NULL,
  idName = "id"
)
}
\arguments{
\item{nFactors}{Number of factors (columns) to generate.}

\item{each}{Number of replications for each combination of factors. Must be specified.}

\item{levels}{Vector or scalar. If a vector is specified, it must be
the same length as nFatctors. Each value of the vector represents the
number of levels of each corresponding factor. If a scalar is specified,
each factor will have the same number of levels. The default is 2 levels
for each factor.}

\item{coding}{String value to specify if "dummy" or "effect" coding is used.
Defaults to "dummy".}

\item{colNames}{A vector of strings, with a length of nFactors. The strings
represent the name for each factor.}

\item{idName}{A string that specifies the id of the record. Defaults to "id".}
}
\value{
A data.table that contains the added simulated data. Each column contains
an integer.
}
\description{
Generate multi-factorial data
}
\examples{
genMultiFac(nFactors = 2, each = 5)
genMultiFac(nFactors = 2, each = 4, levels = c(2, 3))
genMultiFac(nFactors = 3, each = 1, coding = "effect", 
   colNames = c("Fac1","Fac2", "Fac3"), id = "block")
}
