% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmst.R
\name{rmst}
\alias{rmst}
\title{RMST difference of 2 arms}
\usage{
rmst(
  data,
  tau = 10,
  var_label_tte = "tte",
  var_label_event = "event",
  var_label_group = "treatment",
  formula = NULL,
  reference = "control",
  alpha = 0.05
)
}
\arguments{
\item{data}{A time-to-event dataset with a column \code{tte} indicating the
survival time and a column of \code{event} indicating whether it is
event or censor.}

\item{tau}{RMST analysis time.}

\item{var_label_tte}{Column name of the TTE variable.}

\item{var_label_event}{Column name of the event variable.}

\item{var_label_group}{Column name of the grouping variable.}

\item{formula}{(default: \code{NULL}) A formula that indicates the TTE, event, and
group variables (in that exact order; see Details below). This is an
alternative to specifying the variables as strings. If a formula is
provided, the values passed to \code{var_label_tte}, \code{var_label_event}, and
\code{var_label_group} are ignored.}

\item{reference}{A group label indicating the reference group.}

\item{alpha}{Type I error.}
}
\value{
The z statistics.
}
\description{
RMST difference of 2 arms
}
\details{
The argument \code{formula} is provided as a convenience to easily specify the TTE,
event, and grouping variables. Note however that only the order of the three
variables is actually used by the underlying function. Any functions applied
in the formula are ignored, and thus should only be used for documenting your
intent. For example, you can use the syntax from the survival package
\code{Surv(tte | event) ~ group} to highlight the relation between the TTE and
event variables, but the function \code{Surv()} is never actually executed.
Importantly, you shouldn't apply any transformation functions such as \code{log()}
since these will also be ignored.
}
\examples{
data(ex1_delayed_effect)
rmst(
  data = ex1_delayed_effect,
  var_label_tte = "month",
  var_label_event = "evntd",
  var_label_group = "trt",
  tau = 10,
  reference = "0"
)

# Formula interface
library("survival")

rmst(
  data = ex1_delayed_effect,
  formula = Surv(month | evntd) ~ trt,
  tau = 10,
  reference = "0"
)

# alternative
rmst(
  data = ex1_delayed_effect,
  formula = ~ Surv(month, evntd, trt),
  tau = 10,
  reference = "0"
)

# This example doesn't make statistical sense, but demonstrates that only the
# order of the 3 variables actually matters
rmst(
  data = ex1_delayed_effect,
  formula = month ~ evntd + trt,
  tau = 10,
  reference = "0"
)
}
