% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{DR}
\alias{DR}
\title{Create an Drift (DR) Process}
\usage{
DR(omega = NULL)
}
\arguments{
\item{omega}{A \code{double} value for the slope of a DR process (see Note for details).}
}
\value{
An S3 object with called ts.model with the following structure:
\describe{
 \item{process.desc}{Used in summary: "DR"}
 \item{theta}{slope}
 \item{print}{String containing simplified model}
 \item{plength}{Number of parameters}
 \item{obj.desc}{y desc replicated x times}
 \item{obj}{Depth of parameters e.g. list(1)}
 \item{starting}{Guess starting values? TRUE or FALSE (e.g. specified value)}
}
}
\description{
Sets up the necessary backend for the DR process.
}
\note{
We consider the following model: \deqn{Y_t = \omega t}
}
\examples{
DR()
DR(omega=3.4)
}
\author{
James Balamuta
}
