% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/models.R
\name{load_model}
\alias{load_model}
\title{Load a model from file.}
\usage{
load_model(dir, model_name, more_info = FALSE, simulator.files = NULL)
}
\arguments{
\item{dir}{the directory passed to \code{\link{generate_model}})}

\item{model_name}{the Model object's \code{name} attribute}

\item{more_info}{if TRUE, then returns additional information such as
state of RNG after calling \code{\link{generate_model}}}

\item{simulator.files}{if NULL, then \code{getOption("simulator.files")}
will be used.}
}
\description{
After \code{\link{generate_model}} has been called, this function can be used
to load the saved \code{\linkS4class{Model}} object (along with the RNG state and
other information if desired).
}
\details{
Depending on \code{more_info}, either returns \code{\linkS4class{Model}} object
or a list containing \code{\linkS4class{Model}} object and other information.
If simulation object is available, it is easier to use the function
\code{\link{model}} to load the model.
}
\seealso{
\code{\link{generate_model}} \code{\link{model}}
}

