% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/in_silico_system.R
\name{addComplex}
\alias{addComplex}
\title{Adds a regulatory complex in the in silico system.}
\usage{
addComplex(
  insilicosystem,
  compo,
  formationrate = NULL,
  dissociationrate = NULL
)
}
\arguments{
\item{insilicosystem}{The in silico system (see \code{\link{createInSilicoSystem}}).}

\item{compo}{An character vector, each element corresponding to the ID of the genes or regulatory complexes composing the complex. All genes/complexes composing the complex must
have the same biological function (i.e. same \code{TargetReaction} parameter).}

\item{formationrate}{The formation rate of the complex. If none provided, randomly chosen according to the
parameter \code{complexesformationrate_samplingfct} provided in \code{sysargs} (see \code{\link{insilicosystemargs}}).}

\item{dissociationrate}{The dissociation rate of the complex. If none provided, randomly chosen according to the
parameter \code{complexesdissociationrate_samplingfct} provided in \code{sysargs} (see \code{\link{insilicosystemargs}}).}
}
\value{
Returns the modified in silico system.
}
\description{
Adds a regulatory complex in the in silico system with specified parameters (if provided), or with parameters sampled according to the system parameters.
}
\examples{
\donttest{
mysystem = createInSilicoSystem(G = 10, PC.p = 1, PC.TC.p = 1)
mysystem$complexes ## list of complexes existing in the system
mysystem2 = addComplex(mysystem, c(1, 2, 3))
mysystem2$complexes
}
}
