% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfpower.R
\name{dfpower}
\alias{dfpower}
\title{Tabulate BIC of SITAR models by degrees of freedom, fixed effects and xy power transformations}
\usage{
dfpower(
  object,
  df,
  fixed,
  xpowers,
  ypowers,
  FUN = BICadj,
  maxIter = 50,
  drop = TRUE,
  verbose = FALSE
)
}
\arguments{
\item{object}{fitted \pkg{sitar} model to be updated.}

\item{df}{vector of integer spline degrees of freedom to be fitted (defaults to \code{df} in \code{object}).}

\item{fixed}{character vector of fixed effects to be included
(defaults to \code{fixed} in \code{object}, typically 'a + b + c').}

\item{xpowers}{vector of powers to apply to x (defaults to the power of x in \code{object}).}

\item{ypowers}{vector of powers to apply to y (defaults to the power of y in \code{object}).}

\item{FUN}{function to be tabulated (default \code{BICadj}).}

\item{maxIter}{maximum number of iterations per fit (default \code{nlmeControl()$maxIter}).}

\item{drop}{logical which if TRUE (default) drops redundant dimensions and labels from the returned array.}

\item{verbose}{logical controlling monitoring, which gives \code{numIter} for each model.}
}
\value{
Four-way array of returned values, ranked with the largest dimensions first,
and by default with single-level dimensions dropped.

Values are returned with changed sign if the model fit generates a warning, or as
NA if there is an error.
}
\description{
\code{dfpower} fits a series of \pkg{sitar} models tabulated by combinations of
a) specified degrees of freedom for the spline curve,
b) specified fixed effects a, b, c, d,
c) specified power transformations of x, and
d) specified power transformations of y,
returning a four-way array of function values (e.g. BIC) applied to each model.
The function provides a convenient way to optimise the model.
}
\details{
\code{xpowers} and \code{ypowers} treat power 0 as \code{log}. The formula for
\code{x} in \code{object} must be of the form \code{x^power} or \code{fun(x)}, e.g.
\code{x}, \code{x^0.5} or \code{log(x)}. More complex formulae e.g. \code{log(x + 1)}
will fail. In this case fit the model with the variable \code{x1 = x + 1} instead.

\code{FUN} can be any function returning a single numerical value, e.g.
\code{BICadj}, \code{BIC}, \code{AIC}, \code{varexp} or \code{sigma}.

Other fixed effects in \code{object} for covariates in \code{a.formula}, \code{b.formula},
\code{c.formula} or \code{d.formula} are propagated through all the models.
This also applies to the \code{control} argument if set in \code{object}.

The run-time can be shortened by reducing \code{maxIter},
as models often converge quickly or not at all.
}
\examples{
data(heights)
m1 <- sitar(x = age, y = height, id = id, data = heights, df = 4)
\dontshow{
dfpower(m1, df = 4:5, fixed = 'a+c', xpowers = 0, maxIter = 4)
}
\donttest{
dfpower(m1, df = 4:6, fixed = c('a', 'a+b', 'a+c', 'a+b+c'),
  xpowers = 0:1, ypowers = 0:1, maxIter = 8)
}
}
\seealso{
\code{\link{aperm}} transposes the returned array;
\code{\link{addmargins}} adds margins.
}
\author{
Tim Cole \email{tim.cole@ucl.ac.uk}
}
