% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_values.R
\name{sits_values}
\alias{sits_values}
\title{Return the values of a set of time series}
\usage{
sits_values(data, bands = NULL, format = "cases_dates_bands")
}
\arguments{
\item{data}{A sits tibble with time series for different bands.}

\item{bands}{Bands whose values are to be extracted.}

\item{format}{A string with either "cases_dates_bands"
or "bands_cases_dates" or "bands_dates_cases".}
}
\value{
A matrix with values.
}
\description{
This function returns the values of a sits tibble
(according a specified format).
This function is useful to use packages such as ggplot2, dtwclust, or kohonen
that require values that are rowwise or colwise organized.
}
\examples{
# Retrieve a set of time series with 2 classes
data(cerrado_2classes)
# retrieve the values split by bands and dates
ls1 <- sits_values(cerrado_2classes[1:2, ], format = "bands_dates_cases")
# retrieve the values split by cases (occurences)
ls2 <- sits_values(cerrado_2classes[1:2, ], format = "cases_dates_bands")
#' # retrieve the values split by bands and cases (occurences)
ls3 <- sits_values(cerrado_2classes[1:2, ], format = "bands_cases_dates")
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
