% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_config.R
\name{sits_config}
\alias{sits_config}
\title{Configure parameters for sits package}
\usage{
sits_config(
  processing_bloat = NULL,
  rstac_pagination_limit = NULL,
  gdal_creation_options = NULL,
  gdalcubes_chunk_size = NULL,
  reset = FALSE
)
}
\arguments{
\item{processing_bloat}{Estimated growth size of R memory relative
to block size.}

\item{rstac_pagination_limit}{Limit of number of items returned by STAC.}

\item{gdal_creation_options}{GDAL creation options for GeoTiff.}

\item{gdalcubes_chunk_size}{Chunk size to be used by gdalcubes}

\item{reset}{Should current configuration options be
cleaned before loading config files?
Default is \code{FALSE}.}
}
\value{
A list containing the current configuration options.
}
\description{
These functions load and show sits configurations.

The `sits` package uses a configuration file
that contains information on parameters required by different functions.
This includes information about the image collections handled by `sits`.

\code{sits_config()} loads the default configuration file and
the user provided configuration file. The final configuration is
obtained by overriding the options by the values provided in
\code{processing_bloat}, \code{rstac_pagination_limit},
\code{gdal_creation_options} and \code{gdalcubes_chunk_size}
}
\details{
Users can provide additional configuration files, by specifying the
location of their file in the environmental variable
\code{SITS_CONFIG_USER_FILE}.

To see the key entries and contents of the current configuration values,
use \code{sits_config_show()}.
}
\examples{
current_config <- sits_config()
}
\author{
Rolf Simoes, \email{rolf.simoes@inpe.br}
}
