% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_som.R
\name{sits_som_clean_samples}
\alias{sits_som_clean_samples}
\title{Cleans the samples based on SOM map information}
\usage{
sits_som_clean_samples(
  som_map,
  prior_threshold = 0.6,
  posterior_threshold = 0.6,
  keep = c("clean", "analyze")
)
}
\arguments{
\item{som_map}{Returned by \code{\link[sits]{sits_som_map}}.}

\item{prior_threshold}{Threshold of conditional probability
(frequency of samples assigned to the same SOM neuron).}

\item{posterior_threshold}{Threshold of posterior probability
(influenced by the SOM neighborhood).}

\item{keep}{Which types of evaluation to be maintained in the data.}
}
\value{
tibble with an two additional columns.
The first indicates if each sample is clean, should be analyzed or
should be removed. The second is the posterior probability of the sample.
}
\description{
Cleans the samples based on SOM map information
}
\examples{
if (sits_run_examples()) {
    # create a som map
    som_map <- sits_som_map(samples_modis_ndvi)
    # plot the som map
    plot(som_map)
    # evaluate the som map and create clusters
    clusters_som <- sits_som_evaluate_cluster(som_map)
    # plot the cluster evaluation
    plot(clusters_som)
    # clean the samples
    new_samples <- sits_som_clean_samples(som_map)
}

}
