% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sits_view.R
\name{sits_view}
\alias{sits_view}
\alias{sits_view.sits}
\alias{sits_view.data.frame}
\alias{sits_view.som_map}
\alias{sits_view.raster_cube}
\alias{sits_view.uncertainty_cube}
\alias{sits_view.class_cube}
\alias{sits_view.probs_cube}
\alias{sits_view.default}
\title{View data cubes and samples in leaflet}
\usage{
sits_view(x, ...)

\method{sits_view}{sits}(x, ..., legend = NULL, color_palette = "Harmonic")

\method{sits_view}{data.frame}(x, ..., legend = NULL, color_palette = "Harmonic")

\method{sits_view}{som_map}(x, ..., id_neurons, legend = NULL, color_palette = "Harmonic")

\method{sits_view}{raster_cube}(
  x,
  ...,
  band = NULL,
  red = NULL,
  green = NULL,
  blue = NULL,
  tiles = x$tile,
  dates = NULL,
  class_cube = NULL,
  legend = NULL,
  color_palette = "RdYlGn",
  segments = NULL,
  view_max_mb = NULL
)

\method{sits_view}{uncertainty_cube}(
  x,
  ...,
  tiles = x$tile,
  class_cube = NULL,
  legend = NULL,
  color_palette = "Blues",
  segments = NULL,
  view_max_mb = NULL
)

\method{sits_view}{class_cube}(
  x,
  ...,
  tiles = NULL,
  legend = NULL,
  color_palette = "Spectral",
  segments = NULL,
  view_max_mb = NULL
)

\method{sits_view}{probs_cube}(
  x,
  ...,
  tiles = x$tile,
  class_cube = NULL,
  legend = NULL,
  view_max_mb = NULL,
  color_palette = "YlGnBu"
)

\method{sits_view}{default}(x, ...)
}
\arguments{
\item{x}{Object of class "sits", "data.frame", "som_map",
"raster_cube" or "classified image".}

\item{...}{Further specifications for \link{sits_view}.}

\item{legend}{Named vector that associates labels to colors.}

\item{color_palette}{Palette provided in the configuration file.}

\item{id_neurons}{Neurons from the SOM map to be shown.}

\item{band}{For plotting grey images.}

\item{red}{Band for red color.}

\item{green}{Band for green color.}

\item{blue}{Band for blue color.}

\item{tiles}{Tiles to be plotted (in case of a multi-tile cube).}

\item{dates}{Dates to be plotted.}

\item{class_cube}{Classified cube to be overlayed on top on image.}

\item{segments}{Segment list produced by \link{sits_segment}}

\item{view_max_mb}{Maximum size of leaflet to be visualized}
}
\value{
A leaflet object containing either samples or
                      data cubes embedded in a global map that can
                      be visualized directly in an RStudio viewer.
}
\description{
Uses leaflet to visualize time series, raster cube and
classified images
}
\note{
Please refer to the sits documentation available in
<https://e-sensing.github.io/sitsbook/> for detailed examples.
}
\examples{
if (sits_run_examples()) {
    # view samples
    sits_view(cerrado_2classes)
.    # create a local data cube
    data_dir <- system.file("extdata/raster/mod13q1", package = "sits")
    modis_cube <- sits_cube(
        source = "BDC",
        collection = "MOD13Q1-6",
        data_dir = data_dir
    )
    # view the data cube
    sits_view(modis_cube,
        band = "NDVI"
    )
    # train a model
    rf_model <- sits_train(samples_modis_ndvi, sits_rfor())
.    # classify the cube
    modis_probs <- sits_classify(
        data = modis_cube,
        ml_model = rf_model,
        output_dir = tempdir()
    )
    # view the probs
    sits_view(modis_probs)
    # generate a map
    modis_label <- sits_label_classification(
        modis_probs,
        output_dir = tempdir()
    )
.    # view the classified map
    sits_view(modis_label)
.    # view the classified map with the B/W image
    sits_view(modis_cube,
        band = "NDVI",
        class_cube = modis_label,
        dates = sits_timeline(modis_cube)[[1]]
    )
    # view the classified map with the RGB image
    sits_view(modis_cube,
        red = "NDVI", green = "NDVI", blue = "NDVI",
        class_cube = modis_label,
        dates = sits_timeline(modis_cube)[[1]]
    )
    # create an uncertainty cube
    modis_uncert <- sits_uncertainty(
        cube = modis_probs,
        output_dir = tempdir()
    )
    # view the uncertainty cube
    sits_view(modis_uncert)

    # segment the image
    segments <- sits_segment(
        cube = modis_cube,
        tile = "012010",
        bands = "NDVI",
        date = sits_timeline(modis_cube)[1],
        seg_fn = sits_slic(step = 20)
    )
    # view image and segments
    sits_view (
        modis_cube,
        band = "NDVI",
        segments = segments
    )
    # view image, classified image and segments
    sits_view (
        modis_cube,
        red = "NDVI",
        green = "NDVI",
        blue = "NDVI",
        class_cube = modis_label,
        segments = segments
    )
    # view B/W image, classified image and segments
    sits_view (
        modis_cube,
        band = "NDVI",
        class_cube = modis_label,
        segments = segments
    )
    # get the average value per segment
    samples_seg <- sits_get_data(
        cube = modis_cube,
        samples = segments
    )
    # train a model
    tcnn_model <- sits_train(samples_modis_ndvi, sits_tempcnn())
    # classify the segments
    seg_class <- sits_classify(
        data = samples_seg,
        ml_model = tcnn_model
    )

    # add a column to the segments by class
    segments <- sits_join_segments(
        data = seg_class,
        segments = segments
    )
    # view image and classified segments
    sits_view (
        modis_cube,
        band = "NDVI",
        segments = segments
    )
    # view image, classified image and segments
    sits_view (
        modis_cube,
        red = "NDVI",
        green = "NDVI",
        blue = "NDVI",
        class_cube = modis_label,
        segments = segments
    )
}
}
\author{
Gilberto Camara, \email{gilberto.camara@inpe.br}
}
