% Generated by roxygen2 (4.0.1): do not edit by hand
\name{sjc.elbow}
\alias{sjc.elbow}
\title{Compute elbow values of a k-means cluster analysis}
\usage{
sjc.elbow(data, steps = 15, showDiff = FALSE)
}
\arguments{
\item{data}{The data frame containing all variables that should be used for
determining the elbow criteria.}

\item{steps}{The maximum group-count for the k-means cluster analysis for
which the elbow-criterion should be displayed. Default is \code{15}.}

\item{showDiff}{If \code{TRUE}, an additional plot with the differences between
         each fusion step of the Elbow criterion calculation is shown. This plot
         may help identifying the "elbow". Default for this parameter is \code{FALSE}.}
}
\description{
Plot elbow values of a k-means cluster analysis. This function
               computes a k-means cluster analysis on the provided data frame
               and produces two plots: one with the different elbow values
               and a second plot that maps the differences between each
               "step" (i.e. between elbow values) on the y-axis. An
               increase in the second plot may indicate the elbow criterion.
}
\examples{
# plot elbow values of mtcars dataset
sjc.elbow(mtcars)
}
\seealso{
\code{\link{sjc.kgap}} \cr
         \code{\link{sjc.dend}} \cr
         \code{\link{sjc.cluster}} \cr
         \code{\link{sjc.grpdisc}}
}

