% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/sjImportSPSS.R
\name{sji.getVariableLabels}
\alias{sji.getVariableLabels}
\title{Retrieve variable labels of (an SPSS-imported) data frame or of a specific variable}
\usage{
sji.getVariableLabels(x)
}
\arguments{
\item{x}{A data frame (containing imported SPSS data or with attached variable labels) or
         a vector with \code{"variable.label"} attribute.}
}
\value{
A list with all variable labels from the SPSS dataset,
          or a string with the variable label, if \code{x} is a variable.
}
\description{
This function retrieves the variable labels of an imported
               SPSS data set and returns the result as list or the variable
               label of a specific vector / variable and returns it as string.
}
\examples{
# import SPSS data set
# mydat <- sji.SPSS("my_spss_data.sav", enc="UTF-8")

# retrieve variable labels
# mydat.var <- sji.getVariableLabels(mydat)

# retrieve value labels
# mydat.val <- sji.getValueLabels(mydat)

data(efc)
sji.getVariableLabels(efc$e42dep)
}
\seealso{
\itemize{
           \item \href{http://www.strengejacke.de/sjPlot/datainit/}{sjPlot manual: data initialization}
           \item \href{http://www.strengejacke.de/sjPlot/sji.viewSPSS/}{sjPlot manual: inspecting (SPSS imported) data frames}
           \item \code{\link{sji.SPSS}}
           \item \code{\link{sji.getValueLabels}}
           \item \code{\link{sji.convertToLabel}}
           \item \code{\link{sji.convertToValue}}
           \item \code{\link{sji.setValueLabels}}
           }
}

