% Generated by roxygen2 (4.0.2): do not edit by hand
\name{sjt.grpmean}
\alias{sjt.grpmean}
\title{Show grouped means as HTML table}
\usage{
sjt.grpmean(varCount, varGrp, rowLabels = NULL, digits = 2, file = NULL,
  encoding = NULL, CSS = NULL, useViewer = TRUE, no.output = FALSE)
}
\arguments{
\item{varCount}{a numeric vector / variable. Mean, SD and SE for this variable are calculated.}

\item{varGrp}{a (numeric) vector with group indices, used to select sub-groups from \code{varCount}.}

\item{rowLabels}{a character vector of same length as \code{varGrp} unqiue values. In short: the
value labels of \code{varGrp}. Used to name table rows. By default, row labels
are automatically detected if set by \code{sji.setValueLabels}.}

\item{digits}{amount of digits for table values.}

\item{file}{The destination file, which will be in html-format. If no filepath is specified,
the file will be saved as temporary file and openend either in the RStudio View pane or
in the default web browser.}

\item{encoding}{The charset encoding used for variable and value labels. Default is \code{NULL}, so encoding
will be auto-detected depending on your platform (\code{"UTF-8"} for Unix and \code{"Windows-1252"} for
Windows OS). Change encoding if specific chars are not properly displayed (e.g.) German umlauts).}

\item{CSS}{A \code{\link{list}} with user-defined style-sheet-definitions, according to the
\href{http://www.w3.org/Style/CSS/}{official CSS syntax}. See return value \code{page.style} for details
of all style-sheet-classnames that are used in this function. Parameters for this list need:
\enumerate{
  \item the class-names with \code{"css."}-prefix as parameter name and
  \item each style-definition must end with a semicolon
}
You can add style information to the default styles by using a + (plus-sign) as
initial character for the parameter attributes. Examples:
\itemize{
  \item \code{css.table='border:2px solid red;'} for a solid 2-pixel table border in red.
  \item \code{css.summary='font-weight:bold;'} for a bold fontweight in the summary row.
}
See further examples below and the \href{http://www.strengejacke.de/sjPlot/sjtbasics}{sjPlot manual: sjt-basics}.}

\item{useViewer}{If \code{TRUE}, the function tries to show the HTML table in the IDE's viewer pane. If
\code{FALSE} or no viewer available, the HTML table is opened in a web browser.}

\item{no.output}{If \code{TRUE}, the html-output is neither opened in a browser nor shown in
the viewer pane and not even saved to file. This option is useful when the html output
should be used in \code{knitr} documents. The html output can be accessed via the return
value.}
}
\value{
Invisibly returns a \code{\link{structure}} with
         \itemize{
           \item the data frame with the description information (\code{df}),
           \item the web page style sheet (\code{page.style}),
           \item the web page content (\code{page.content}),
           \item the complete html-output (\code{output.complete}) and
           \item the html-table with inlin-css for use with knitr (\code{knitr})
           }
           for further use.
}
\description{
Computes mean, sd and se for each sub-group (indicated by \code{varGrp})
               of \code{varCount} as prints the result as HTML table.
}
\examples{
\dontrun{
data(efc)
sjt.grpmean(efc$c12hour,
            efc$e42dep)}
}
\seealso{
\code{\link{sjp.aov1}}
}

