% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/sjPlotLikert.R
\name{sjp.likert}
\alias{sjp.likert}
\title{Plot likert scales as centered stacked bars}
\usage{
sjp.likert(items, catcount = NULL, cat.neutral = NULL, weightBy = NULL,
  weightByTitleString = NULL, sort.frq = NULL, geom.size = 0.6,
  geom.colors = "BrBG", reverse.colors = FALSE,
  cat.neutral.color = "grey70", intercept.line.color = "grey50",
  value.labels = "show", showPercentageSign = FALSE, labelDigits = 1,
  legendLabels = NULL, hideLegend = FALSE, title = NULL,
  legendTitle = NULL, includeN = TRUE, showItemLabels = TRUE,
  axisLabels.y = NULL, breakTitleAt = 50, breakLabelsAt = 30,
  breakLegendTitleAt = 30, breakLegendLabelsAt = 28, gridRange = 1,
  gridBreaksAt = 0.2, expand.grid = TRUE, axisTitle.x = NULL,
  axisTitle.y = NULL, coord.flip = TRUE, printPlot = TRUE)
}
\arguments{
\item{items}{\code{\link{data.frame}} with each column representing one likert-item.}

\item{catcount}{optional, amount of categories of \code{items} (e.g. \emph{"strongly disagree",
"disagree", "agree"} and \emph{"strongly agree"} would be \code{catcount = 4}).
Note that this argument only applies to "valid" answers, i.e. if you
have an additional neutral category (see \code{cat.neutral}) like \emph{"don't know"},
this won't count for \code{catcount} (e.g. "strongly disagree",
"disagree", "agree", "strongly agree" and neutral category "don't know"
would still mean that \code{catcount = 4}). See 'Note'.}

\item{cat.neutral}{if there's a neutral category (like "don't know" etc.), specify
the index number (value) for this category. Else, set \code{cat.neutral = NULL} (default).
The proportions of neutral category answers are plotted as grey bars on the left side of
the figure.}

\item{weightBy}{weight factor that will be applied to weight all cases of \code{items}.
Must be a vector of same length as \code{nrow(items)}. Default is \code{NULL},
so no weights are used.}

\item{weightByTitleString}{suffix (as string) for the plot's title, if \code{weightBy} is specified,
e.g. \code{weightByTitleString=" (weighted)"}. Default is \code{NULL}, so plot's
title will not have a suffix when cases are weighted.}

\item{sort.frq}{indicates whether the items of \code{items} should be ordered by
total sum of positive or negative answers.
\describe{
  \item{\code{"pos.asc"}}{to order ascending by sum of positive answers}
  \item{\code{"pos.desc"}}{to order descending by sum of positive answers}
  \item{\code{"neg.asc"}}{for sorting ascending negative answers}
  \item{\code{"neg.desc"}}{for sorting descending negative answers}
  \item{\code{NULL}}{(default) for no sorting}
}}

\item{geom.size}{width of bars. Recommended values for this argument are from 0.4 to 1.5}

\item{geom.colors}{user defined color palette for geoms. If specified, must either be vector with color values
of same length as groups defined in \code{legendLabels}, or a specific color palette code.
See 'Note' in \code{\link{sjp.grpfrq}}.}

\item{reverse.colors}{logical, if \code{TRUE}, the color scale from \code{geom.colors} will be reversed,
so positive and negative values switch colors.}

\item{cat.neutral.color}{color of the neutral category, if plotted (see \code{cat.neutral}).}

\item{intercept.line.color}{color of the vertical intercept line that divides positive and negative values.}

\item{value.labels}{determines style and position of percentage value labels on the bars:
\describe{
  \item{\code{"show"}}{(default) shows percentage value labels in the middle of each category bar}
  \item{\code{"hide"}}{hides the value labels, so no percentage values on the bars are printed}
  \item{\code{"sum.inside"}}{shows the sums of percentage values for both negative and positive values and prints them inside the end of each bar}
  \item{\code{"sum.outide"}}{shows the sums of percentage values for both negative and positive values and prints them outside the end of each bar}
}}

\item{showPercentageSign}{logical, if \code{TRUE}, \%-signs for value labels are shown.}

\item{labelDigits}{amount of digits for rounding \code{value.labels}. Default is 1,
i.e. value labels have 1 digit after decimal point.}

\item{legendLabels}{list or character vector that indicate the names of the
likert-scale-categories and which appear as legend text.}

\item{hideLegend}{logical, indicates whether legend (guide) should be shown or not.}

\item{title}{plot title as string. Example: \code{title = "my title"}.
Use \code{NULL} to automatically detect variable names that will be used as title
(see \code{\link[sjmisc]{set_label}}) for details). If \code{title = ""},
no title is printed.}

\item{legendTitle}{title of the plot legend, as string.}

\item{includeN}{logical, if \code{TRUE} (default), the N of each item will be included in axis labels.}

\item{showItemLabels}{logical, whether x-axis text (category names) should be shown or not}

\item{axisLabels.y}{character vector with labels for the y-axis (names of the
\code{items}). Example: \code{axisLabels.y = c("Q1", "Q2", "Q3")}.
Axis labels will automatically be detected, when they have
label attributes (see \code{\link[sjmisc]{set_label}} for details).}

\item{breakTitleAt}{determines how many chars of the plot title are displayed in
one line and when a line break is inserted into the title.}

\item{breakLabelsAt}{determines how many chars of the category labels are displayed in
one line and when a line break is inserted.}

\item{breakLegendTitleAt}{determines how many chars of the legend's title
are displayed in one line and when a line break is inserted.}

\item{breakLegendLabelsAt}{determines how many chars of the legend labels are
displayed in one line and when a line break is inserted.}

\item{gridRange}{numeric, limits of the x-axis-range, as proportion of 100.
Default is 1, so the x-scale ranges from zero to 100\% on
both sides from the center. You can use values beyond 1
(100\%) in case bar labels are not printed because they exceed the axis range.
E.g. \code{gridRange = 1.4} will set the axis from -140 to +140\%, however, only
(valid) axis labels from -100 to +100\% are printed. Neutral categories are
adjusted to the most left limit.}

\item{gridBreaksAt}{set breaks for the axis, i.e. at every \code{gridBreaksAt}'th
position a major grid is being printed.}

\item{expand.grid}{logical, if \code{TRUE}, the plot grid is expanded, i.e. there is a small margin between
axes and plotting region. Default is \code{FALSE}.}

\item{axisTitle.x}{title for the x-axis. Default is \code{NULL} (no title).}

\item{axisTitle.y}{title for the y-axis. Default is \code{NULL} (no title).}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{printPlot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{df.neg} for the negative values,
          \code{df.pos} for the positive values and \code{df.neutral} for the neutral category values).
}
\description{
Plot likert scales as centered stacked bars.
}
\note{
Note that only even numbers of categories are possible to plot, so the "positive"
       and "negative" values can be splitted into two halfs. A neutral category (like "don't know")
       can be used, but must be indicated by \code{cat.neutral}. \cr \cr
       The \code{catcount}-argument indicates how many item categories are in the
       Likert scale. Normally, this argument can be ignored because the amount of
       valid categories is retrieved automatically. However, sometimes (for instance,
       if a certain category is missing in all items), auto-detection of the amount
       of categories fails. In such cases, specify the amount of categories
       with the \code{catcount}-argument.
}
\examples{
# prepare data for dichotomous likert scale, 5 items
likert_2 <- data.frame(
  as.factor(sample(1:2, 500, replace = TRUE, prob = c(0.3,0.7))),
  as.factor(sample(1:2, 500, replace = TRUE, prob = c(0.6,0.4))),
  as.factor(sample(1:2, 500, replace = TRUE, prob = c(0.25,0.75))),
  as.factor(sample(1:2, 500, replace = TRUE, prob = c(0.9,0.1))),
  as.factor(sample(1:2, 500, replace = TRUE, prob = c(0.35,0.65))))

# create labels
levels_2 <- c("Agree", "Disagree")

# prepare data for 4-category likert scale, with neutral category 5 items
Q1 <- as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.2, 0.3, 0.1, 0.4)))
Q2 <- as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.5, 0.25, 0.15, 0.1)))
Q3 <- as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.25, 0.1, 0.4, 0.25)))
Q4 <- as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.1, 0.4, 0.4, 0.1)))
Q5 <- as.factor(sample(1:4, 500, replace = TRUE, prob = c(0.35, 0.25, 0.15, 0.25)))

likert_4 <- data.frame(Q1, Q2, Q3, Q4, Q5)

# create labels
levels_4 <- c("Strongly agree",
              "Agree",
              "Disagree",
              "Strongly Disagree",
              "Don't know")

# prepare data for 6-category likert scale, 5 items
likert_6 <- data.frame()

Q1 <- as.factor(sample(1:6, 500, replace = TRUE, prob = c(0.2,0.1,0.1,0.3,0.2,0.1)))
Q2 <- as.factor(sample(1:6, 500, replace = TRUE, prob = c(0.15,0.15,0.3,0.1,0.1,0.2)))
Q3 <- as.factor(sample(1:6, 500, replace = TRUE, prob = c(0.2,0.25,0.05,0.2,0.2,0.2)))
Q4 <- as.factor(sample(1:6, 500, replace = TRUE, prob = c(0.2,0.1,0.1,0.4,0.1,0.1)))
Q5 <- as.factor(sample(1:6, 500, replace = TRUE, prob = c(0.1,0.4,0.1,0.3,0.05,0.15)))

likert_6 <- data.frame(Q1, Q2, Q3, Q4, Q5)

# create labels
levels_6 <- c("Very strongly agree", "Strongly agree", "Agree",
              "Disagree", "Strongly disagree", "Very strongly disagree")

# create item labels
items <- c("Q1", "Q2", "Q3", "Q4", "Q5")

# plot dichotomous likert scale, ordered by "negative" values
sjp.likert(likert_2,
           geom.colors = c("green", "red"),
           legendLabels = levels_2,
           axisLabels.y = items,
           sort.frq = "neg.desc")

# plot 4-category-likert-scale, no order
sjp.likert(likert_4,
           cat.neutral = 5,
           legendLabels = levels_4,
           axisLabels.y = items,
           gridRange = 1.2,
           expand.grid = FALSE,
           value.labels = "sum.outside",
           showPercentageSign = TRUE)

# plot 6-category-likert-scale, ordered by positive values,
# in brown color scale
sjp.likert(likert_6,
           legendLabels = levels_6,
           axisLabels.y = items,
           sort.frq = "pos.asc",
           labelDigits = 0,
           showPercentageSign = TRUE,
           value.labels = "sum.inside")
}
\seealso{
\href{http://www.strengejacke.de/sjPlot/sjp.likert/}{sjPlot manual: sjp.likert}
}

