% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotLinregMultiple.R
\name{sjp.lmm}
\alias{sjp.lmm}
\title{Plot estimates of multiple fitted lm(er)'s}
\usage{
sjp.lmm(..., type = "lm", remove.estimates = NULL, title = NULL,
  depvar.labels = NULL, legend.title = "Dependent Variables",
  legend.pval.title = "p-level", axis.labels = NULL,
  axis.title = "Estimates", axis.lim = NULL, wrap.title = 50,
  wrap.labels = 25, wrap.legend.title = 20, grid.breaks = NULL,
  geom.size = 3, geom.spacing = 0.4, geom.colors = "Set1",
  show.values = TRUE, show.legend = TRUE, show.intercept = FALSE,
  show.p = TRUE, fade.ns = FALSE, p.shape = FALSE, p.kr = TRUE,
  vline.type = 2, vline.color = "grey70", digits = 2,
  facet.grid = FALSE, coord.flip = TRUE, prnt.plot = TRUE)
}
\arguments{
\item{...}{one or more fitted \code{lm} or \code{lmerMod}-objects. May also 
be a \code{\link{list}}-object with fitted models, instead of separating 
each model with comma. See 'Examples'.}

\item{type}{type of plot. Use one of following:
\describe{
  \item{\code{"lm"}}{(default) for forest-plot like plot of estimates.}
  \item{\code{"std"}}{for forest-plot like plot of standardized beta values.}
  \item{\code{"std2"}}{for forest-plot like plot of standardized beta values, however, standardization is done by rescaling estimates by dividing them by two sd (see 'Details' in \code{\link{sjp.lm}}).}
}}

\item{remove.estimates}{character vector with coefficient names that indicate
which estimates should be removed from the plot.
\code{remove.estimates = "est_name"} would remove the estimate \emph{est_name}. Default
is \code{NULL}, i.e. all estimates are printed.}

\item{title}{character vector, used as plot title. Depending on plot type and function,
will be set automatically. If \code{title = ""}, no title is printed.}

\item{depvar.labels}{character vector with labels of dependent 
variables of all fitted models. See 'Examples'.}

\item{legend.title}{character vector, used as title for the plot legend. Note that
only some plot types have legends (e.g. \code{type = "pred"} or when
grouping estimates with \code{group.estimates}).}

\item{legend.pval.title}{character vector, used as title of the plot legend that 
indicates the p-values. Default is \code{"p-level"}. Only applies if \code{p.shape = TRUE}.}

\item{axis.labels}{character vector with labels used as axis labels. Optional
argument, since in most cases, axis labels are set automatically.}

\item{axis.title}{character vector of length one or two (depending on
the plot function and type), used as title(s) for the x and y axis. 
If not specified, a default labelling  is chosen.}

\item{axis.lim}{numeric vector of length 2, defining the range of the plot axis.
Depending on plot type, may effect either x- or y-axis, or both.
For multiple plot outputs (e.g., from \code{type = "eff"} or 
\code{type = "slope"} in \code{\link{sjp.glm}}), \code{axis.lim} may
also be a list of vectors of length 2, defining axis limits for each
plot (only if non-faceted).}

\item{wrap.title}{numeric, determines how many chars of the plot title are displayed in
one line and when a line break is inserted.}

\item{wrap.labels}{numeric, determines how many chars of the value, variable or axis 
labels are displayed in one line and when a line break is inserted.}

\item{wrap.legend.title}{numeric, determines how many chars of the legend's title 
are displayed in one line and when a line break is inserted.}

\item{grid.breaks}{numeric; sets the distance between breaks for the axis, 
i.e. at every \code{grid.breaks}'th position a major grid is being printed.}

\item{geom.size}{size resp. width of the geoms (bar width, line thickness or point size, 
depending on plot type and function). Note that bar and bin widths mostly 
need smaller values than dot sizes.}

\item{geom.spacing}{spacing between the dots and error bars of the plotted fitted models. Default
is 0.3.}

\item{geom.colors}{user defined color palette for geoms. If \code{group.estimates}
is \emph{not} specified, must either be vector with two color values or a specific
color palette code (see 'Details' in \code{\link{sjp.grpfrq}}). Else, if
\code{group.estimates} is specified, \code{geom.colors} must be a vector
of same length as groups. See 'Examples'.}

\item{show.values}{logical, whether values should be plotted or not.}

\item{show.legend}{logical, if \code{TRUE}, and depending on plot type and
function, a legend is added to the plot.}

\item{show.intercept}{logical, if \code{TRUE}, the intercept of the fitted model is also plotted.
Default is \code{FALSE}. For \code{glm}'s, please note that due to exponential 
transformation of estimates, the intercept in some cases can not be calculated, thus the
function call is interrupted and no plot printed.}

\item{show.p}{logical, adds significance levels to values, or value and 
variable labels.}

\item{fade.ns}{if \code{TRUE}, non significant estimates will be printed in slightly faded colors.}

\item{p.shape}{If \code{TRUE}, significant levels are distinguished by different point shapes and a related
legend is plotted. Default is \code{FALSE}.}

\item{p.kr}{logical, if \code{TRUE}, p-value estimation is based on conditional 
F-tests with Kenward-Roger approximation for the df. Caution: Computation
may take very long time for large samples!}

\item{vline.type}{linetype of the vertical "zero point" line. Default is \code{2} (dashed line).}

\item{vline.color}{color of the vertical "zero point" line. Default value is \code{"grey70"}.}

\item{digits}{numeric, amount of digits after decimal point when rounding estimates and values.}

\item{facet.grid}{\code{TRUE} to arrange the lay out of of multiple plots 
in a grid of an integrated single plot.}

\item{coord.flip}{logical, if \code{TRUE}, the x and y axis are swapped.}

\item{prnt.plot}{logical, if \code{TRUE} (default), plots the results as graph. Use \code{FALSE} if you don't
want to plot any graphs. In either case, the ggplot-object will be returned as value.}
}
\value{
(Insisibily) returns the ggplot-object with the complete plot (\code{plot}) as well as the data frame that
          was used for setting up the ggplot-object (\code{data}).
}
\description{
Plot and compare coefficients (estimates) with confidence 
               intervals of  multiple fitted linear (mixed effects) models 
               in one plot. 
               Fitted models may have differing predictors, but only
               in a "stepwise" sense.
}
\note{
The fitted models may have differing predictors, but only in a 
        "stepwise" sense; i.e., models should share a common set of predictors,
        while some models may have additional predictors (e.g. added via
        the \code{\link[stats]{update}} function). See 'Examples'.
}
\examples{
# prepare dummy variables for binary logistic regression
# Now fit the models. Note that all models share the same predictors
# and only differ in their dependent variable
library(sjmisc)
data(efc)

# fit three models
fit1 <- lm(barthtot ~ c160age + c12hour + c161sex + c172code, data = efc)
fit2 <- lm(neg_c_7 ~ c160age + c12hour + c161sex + c172code, data = efc)
fit3 <- lm(tot_sc_e ~ c160age + c12hour + c161sex + c172code, data = efc)

# plot multiple models
sjp.lmm(fit1, fit2, fit3, facet.grid = TRUE)

# plot multiple models with legend labels and 
# point shapes instead of value labels
sjp.lmm(fit1, fit2, fit3,
        axis.labels = c("Carer's Age", "Hours of Care", "Carer's Sex",
                        "Educational Status"),
        depvar.labels = c("Barthel Index", "Negative Impact", "Services used"),
        show.values = FALSE, show.p = FALSE, fade.ns = TRUE, p.shape = TRUE)

# ------------------------------
# plot multiple models from nested lists argument
# ------------------------------
all.models <- list()
all.models[[1]] <- fit1
all.models[[2]] <- fit2
all.models[[3]] <- fit3

sjp.lmm(all.models)

# ------------------------------
# plot multiple models with different
# predictors (stepwise inclusion),
# standardized estimates
# ------------------------------
fit1 <- lm(mpg ~ wt + cyl + disp + gear, data = mtcars)
fit2 <- update(fit1, . ~ . + hp)
fit3 <- update(fit2, . ~ . + am)

sjp.lmm(fit1, fit2, fit3, type = "std2")

}

