% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sjPlotClusterAnalysis.R
\name{sjc.grpdisc}
\alias{sjc.grpdisc}
\title{Compute a linear discriminant analysis on classified cluster groups}
\usage{
sjc.grpdisc(data, groups, groupcount, clss.fit = TRUE)
}
\arguments{
\item{data}{A data frame with variables that should be used for the
cluster analysis.}

\item{groups}{group classification of the cluster analysis that was returned
from the \code{\link{sjc.cluster}}-function}

\item{groupcount}{amount of groups (clusters) that should be used. Use
\code{\link{sjc.elbow}} to determine the group-count depending
on the elbow-criterion.}

\item{clss.fit}{logical, if \code{TRUE} (default), a vertical line indicating the
overall goodness of classification is added to the plot, so one can see
whether a certain group is below or above the average classification goodness.}
}
\value{
(Invisibly) returns an object with
          \itemize{
           \item \code{data}: the used data frame for plotting,
           \item \code{plot}: the ggplot object,
           \item \code{accuracy}: a vector with the accuracy of classification for each group,
           \item \code{total.accuracy}: the total accuracy of group classification.
          }
}
\description{
Computes linear discriminant analysis on classified cluster groups.
               This function plots a bar graph indicating the goodness of classification
               for each group.
}
\examples{
# retrieve group classification from hierarchical cluster analysis
# on the mtcars data set (5 groups)
groups <- sjc.cluster(mtcars, 5)

# plot goodness of group classificatoin
sjc.grpdisc(mtcars, groups, 5)

}
