% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/zap_labels.R
\name{zap_labels}
\alias{zap_labels}
\title{Convert labelled values into NA}
\usage{
zap_labels(x)
}
\arguments{
\item{x}{(partially) \code{\link[haven]{labelled}} vector, \code{data.frame} or \code{list}
of (partially) labelled vectors}
}
\value{
\code{x}, where all labelled values are converted to \code{NA}.
}
\description{
Convert labelled values into NA
}
\examples{
data(efc)
str(efc$e42dep)

x <- set_labels(efc$e42dep,
                c(`1` = "independent",
                  `4` = "severe dependency"))
table(x)
get_values(x)
str(x)

# zap all labelled values
x <- set_labels(efc$e42dep,
                c(`1` = "independent",
                  `4` = "severe dependency"))
table(zap_labels(x))
get_values(zap_labels(x))
str(zap_labels(x))

# zap all unlabelled values
x <- set_labels(efc$e42dep,
                c(`1` = "independent",
                  `4` = "severe dependency"))
table(zap_unlabelled(x))
get_values(zap_unlabelled(x))
str(zap_unlabelled(x))
}
\seealso{
\code{\link{get_values}} and \code{\link{zap_unlabelled}}
}

