% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_labels.R, R/remove_labels.R
\name{add_labels}
\alias{add_labels}
\alias{add_labels<-}
\alias{remove_labels}
\alias{remove_labels<-}
\alias{replace_labels}
\alias{replace_labels<-}
\title{Add, replace or remove value labels of variables}
\usage{
add_labels(x, value)

add_labels(x) <- value

replace_labels(x, value)

replace_labels(x) <- value

remove_labels(x, value)

remove_labels(x) <- value
}
\arguments{
\item{x}{A variable, data frame or list-object.}

\item{value}{\describe{
\item{For \code{add_labels()}}{A named (numeric) vector of labels
that will be added to \code{x} as label attribute. If \code{x} is
a data frame, \code{value} will be applied to each column of \code{x}.}
\item{For \code{remove_labels()}}{Either a numeric vector, indicating
the position of one or more label attributes that should be removed;
a character vector with names of label attributes that should be
removed; or a \code{\link[haven]{tagged_na}} to remove the labels
from specific NA values.}
}}
}
\value{
\code{x} with additional or removed value labels.
}
\description{
These functions add, replace or remove value labels to or from variables.
}
\details{
\code{add_labels()} adds \code{value} to the existing value
         labels of \code{x}, however, unlike \code{\link{set_labels}}, it
         does \emph{not} remove labels that were \emph{not} specified in
         \code{value}. \code{add_labels()} also replaces existing
         value labels, but preserves the remaining labels.
         \cr \cr
         \code{remove_labels()} is the counterpart to \code{add_labels()}.
         It removes labels from a label attribute of \code{x}.
         \cr \cr
         \code{replace_labels()} is an alias for \code{add_labels()}.
}
\examples{
# ----------------------
# add_labels()
# ----------------------
data(efc)
get_labels(efc$e42dep)

x <- add_labels(efc$e42dep, c(`nothing` = 5))
get_labels(x)

x <- add_labels(efc$e42dep, c(`nothing` = 5, `zero value` = 0))
get_labels(x, include.values = "p")

# replace old value labels
x <- add_labels(efc$e42dep, c(`not so dependent` = 4, `lorem ipsum` = 5))
get_labels(x, include.values = "p")

# replace values, alternative function call
replace_labels(x) <- c(`new second` = 2)

# replace specific missing value (tagged NA)
library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current NA values
x
# tagged NA(c) has currently the value label "First", will be
# replaced by "Second" now.
replace_labels(x, c("Second" = tagged_na("c")))


# ----------------------
# remove_labels()
# ----------------------
x <- remove_labels(efc$e42dep, 2)
get_labels(x, include.values = "p")

x <- remove_labels(efc$e42dep, "independent")
get_labels(x, include.values = "p")

library(haven)
x <- labelled(c(1:3, tagged_na("a", "c", "z"), 4:1),
              c("Agreement" = 1, "Disagreement" = 4, "First" = tagged_na("c"),
                "Refused" = tagged_na("a"), "Not home" = tagged_na("z")))
# get current NA values
get_na(x)
get_na(remove_labels(x, tagged_na("c")))

}
\seealso{
\code{\link{set_label}} to manually set variable labels or
           \code{\link{get_label}} to get variable labels; \code{\link{set_labels}} to
           add value labels, replacing the existing ones (and removing non-specified
           value labels).
}

