% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_cases.R
\name{add_variables}
\alias{add_variables}
\alias{add_case}
\title{Add variables or cases to data frames}
\usage{
add_variables(data, ..., .after = Inf, .before = NULL)

add_case(data, ..., .after = Inf, .before = NULL)
}
\arguments{
\item{data}{A data frame. For \code{add_columns()}, will be bound after data
frames specified in \code{...}. For \code{replace_columns()}, duplicated
columns in \code{data} will be replaced by columns in \code{...}.}

\item{...}{One or more names vectors that indicate the variables or values,
which will be added as new column or row to \code{data}. For \code{add_cases()},
non-matching columns in \code{data} will be filled with \code{NA}.}

\item{.after, .before}{Numerical index of row or column, after or infront of what
the new variable or case should be added. If \code{.after = -1}, variables
or cases are added at the beginning; if \code{.after = Inf},
variables and cases are added at the end. In case of \code{add_variables()},
\code{.after} and \code{.before} may also be a character name indicating
the column in \code{data}, after or infront of what \code{...} should be
inserted.}
}
\value{
\code{data}, including the new variables or cases from \code{...}.
}
\description{
\code{add_variables()} adds a new column to a data frame, while
  \code{add_cases()} adds a new row to a data frame. These are convenient
  functions to add columns or rows not only at the end of a data frame,
  but at any column or row position. Furthermore, they allow easy integration
  into a pipe-workflow.
}
\note{
For \code{add_case()}, if variable does not exist, a new variable is
   created and existing cases for this new variable get the value \code{NA}.
   See 'Examples'.
}
\examples{
d <- data.frame(
  a = c(1, 2, 3),
  b = c("a", "b", "c"),
  c = c(10, 20, 30),
  stringsAsFactors = FALSE
)

add_case(d, b = "d")
add_case(d, b = "d", a = 5, .before = 1)

# adding a new case for a new variable
add_case(d, e = "new case")

add_variables(d, new = 5)
add_variables(d, new = c(4, 4, 4), new2 = c(5, 5, 5), .after = "b")

}
