% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anscombe.R
\name{anscombe}
\alias{anscombe}
\title{Anscombe's Test for Heteroskedasticity in a Linear Regression Model}
\usage{
anscombe(mainlm, studentise = TRUE, statonly = FALSE)
}
\arguments{
\item{mainlm}{Either an object of \code{\link[base]{class}} \code{"lm"}
(e.g., generated by \code{\link[stats]{lm}}), or
a list of two objects: a response vector and a design matrix. The objects
are assumed to be in that order, unless they are given the names
\code{"X"}  and \code{"y"} to distinguish them. The design matrix passed
in a list must begin with a column of ones if an intercept is to be
included in the linear model. The design matrix passed in a list should
not contain factors, as all columns are treated 'as is'. For tests that
use ordinary least squares residuals, one can also pass a vector of
residuals in the list, which should either be the third object or be
named \code{"e"}.}

\item{studentise}{A logical. Should studentising modification of
\insertCite{Bickel78;textual}{skedastic} be implemented? Defaults to
\code{TRUE}; if \code{FALSE}, the original form of the test proposed by
\insertCite{Anscombe61;textual}{skedastic} is used.}

\item{statonly}{A logical. If \code{TRUE}, only the test statistic value
is returned, instead of an object of \code{\link[base]{class}}
\code{"htest"}. Defaults to \code{FALSE}.}
}
\value{
An object of \code{\link[base]{class}} \code{"htest"}. If object is
   not assigned, its attributes are displayed in the console as a
   \code{\link[tibble]{tibble}} using \code{\link[broom]{tidy}}.
}
\description{
This function implements the method of
   \insertCite{Anscombe61;textual}{skedastic} for testing for
   heteroskedasticity in a linear regression model, with or without the
   studentising modification of
   \insertCite{Bickel78;textual}{skedastic}.
}
\details{
Anscombe's Test is among the earliest suggestions for heteroskedasticity
   diagnostics in the linear regression model. The test is not based on
   formally derived theory but on a test statistic that Anscombe intuited
   to be approximately standard normal under the null hypothesis of
   homoskedasticity. \insertCite{Bickel78;textual}{skedastic} discusses
   the test and suggests a studentising modification (included in this
   function) as well as a robustifying modification
   (included in \code{\link{bickel}}). The test is two-tailed.

The original form of the test is as follows.
}
\examples{
mtcars_lm <- lm(mpg ~ wt + qsec + am, data = mtcars)
anscombe(mtcars_lm)
anscombe(mtcars_lm, studentise = FALSE)
# Same as first example
mtcars_list <- list("y" = mtcars$mpg, "X" = cbind(1, mtcars$wt, mtcars$qsec, mtcars$am))
anscombe(mtcars_list)

}
\references{
{\insertAllCited{}}
}
\seealso{
\code{\link{bickel}}, which is a robust extension of this test.
}
