% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-rewrite.R
\name{make_rule}
\alias{make_rule}
\title{Make a AST transformation rule}
\usage{
make_rule(from, to)
}
\arguments{
\item{from}{A character string.}

\item{to}{A character string.}
}
\value{
A function that takes a language object and returns a language object.
}
\description{
Make a AST transformation rule
}
\examples{
library(sketch)

rule_1 <- make_rule("pi", "Math.PI")
expr <- rlang::parse_expr("2 * (3 + pi)")

rule_1(expr)  # this works but is not the preferred usage
rewrite(expr, list(rule_1))  # this is preferred

rule_2 <- make_rule("+", "Math.add")
rewrite(expr, list(rule_1, rule_2))

}
