% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skim.R
\name{skim}
\alias{skim}
\title{Get useful summary statistic from a data frame}
\usage{
skim(.data, ...)
}
\arguments{
\item{.data}{A tbl, or an object that can be coerced into a tbl.}

\item{...}{Additional options, normally used to list individual unquoted column names.}
}
\value{
A \code{skim_df} object, which can be treated like a
 tbl in most instances.
}
\description{
\code{skim} handles data of all types, dispatching a different set of
summary functions based on the types of columns in the data frame.
It is an intentionally simple function. See \code{\link{skim_with}} and
\code{\link{skim_format}} for how \code{skim} can be customized.
If the rendered examples show unencoded values such as `<U+2587>` you
will need to change your locale to allow proper rendering. Please 
review the Using Skimr vignette for more information.
}
\examples{
skim(iris)

# Skim also works groupwise
dplyr::group_by(iris) \%>\% skim()
}
