% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{stats}
\alias{stats}
\alias{n_missing}
\alias{n_complete}
\alias{sorted_count}
\alias{inline_hist}
\alias{n_empty}
\alias{min_char}
\alias{max_char}
\alias{n_unique}
\alias{ts_start}
\alias{ts_end}
\alias{inline_linegraph}
\alias{list_lengths_min}
\alias{list_lengths_median}
\alias{list_lengths_max}
\alias{list_min_length}
\alias{list_max_length}
\title{Summary statistic functions}
\usage{
n_missing(x)

n_complete(x)

sorted_count(x)

inline_hist(x)

n_empty(x)

min_char(x)

max_char(x)

n_unique(x)

ts_start(x)

ts_end(x)

inline_linegraph(x)

list_lengths_min(x)

list_lengths_median(x)

list_lengths_max(x)

list_min_length(x)

list_max_length(x)
}
\arguments{
\item{x}{A vector}
}
\description{
Skimr provides extensions to a variety of functions with R's stats package
to simplify creating summaries of data. All functions are vectorized and take
a single argument. Other parameters for these functions are set in the
\code{\link[=skim_format]{skim_format()}} function.
}
\section{Functions}{
\itemize{
\item \code{n_missing}: Calculate the sum of \code{NA} and \code{NULL} (i.e. missing) values.

\item \code{n_complete}: Calculate complete values; complete values are not missing.

\item \code{sorted_count}: Create a contingency table and arrange its levels in
descending order. In case of ties, the ordering of results is alphabetical
and depends upon the locale. \code{NA} is treated as a ordinary value for
sorting.

\item \code{inline_hist}: Generate inline histogram for numeric variables. The
character length of the histogram is controlled by the formatting options
for character vectors.

\item \code{n_empty}: Calculate the number of blank values in a character vector.
A "blank" is equal to "".

\item \code{min_char}: Calculate the minimum number of characters within a
character vector.

\item \code{max_char}: Calculate the maximum number of characters within a
character vector.

\item \code{n_unique}: Calculate the number of unique elements but remove \code{NA}.

\item \code{ts_start}: Get the start for a time series without the frequency.

\item \code{ts_end}: Get the finish for a time series without the frequency.

\item \code{inline_linegraph}: Generate inline line graph for time series variables. The
character length of the line graph is controlled by the formatting options
for character vectors.
Based on the function in the pillar package.

\item \code{list_lengths_min}: Get the length of the shortest list in a vector of lists.

\item \code{list_lengths_median}: Get the median length of the lists.

\item \code{list_lengths_max}: Get the maximum length of the lists.

\item \code{list_min_length}: Get the length of the shortest list in a vector of lists.

\item \code{list_max_length}: Get the length of the longest list in a vector of lists.
}}

\seealso{
\code{\link[=skim_format]{skim_format()}} and \code{\link[purrr:partial]{purrr::partial()}} for setting arguments of a
skimmer function.
}
