% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{skim_with}
\alias{skim_with}
\alias{skim_with_defaults}
\title{Set or add the summary functions for a particular type of data}
\usage{
skim_with(..., append = TRUE)

skim_with_defaults()
}
\arguments{
\item{...}{A list of functions, with an argument name that matches a
particular data type.}

\item{append}{Whether the provided options should be in addition to the
defaults already in skim for the given types specified by the named
arguments in \code{...}. Default is \code{TRUE}.}
}
\value{
Nothing. \code{invisible(NULL)}
}
\description{
While skim is designed around having an opinionated set of defaults, you
can use this function to change the summary statistics that it returns.
To do that, provide type you wish to change as an argument to this function,
along with a list of named functions that you want to use instead of the
defaults. The \code{append} argument lets you decide whether you want to
replace the defaults or add to them.
}
\details{
This function is not pure. It sets values in within the package environment.
This is an intentional design choice, with effects similar to setting
options in base R. By setting options here for your entire session, you
can continue to summarize using skim on its own.

If the rendered examples show unencoded values such as `<U+2587>` you
will need to change your locale to allow proper rendering. Please 
review the Using Skimr vignette for more information.
}
\section{Functions}{
\itemize{
\item \code{skim_with_defaults}: Use the default functions within skim
}}

\examples{
# Use new functions for numeric functions
skim_with(numeric = list(median = median, mad = mad), append = FALSE)
skim(faithful)

# If you want to remove a particular skimmer, set it to NULL
# This removes the inline histogram
skim_with(numeric = list(hist = NULL))
skim(faithful)

# Go back to defaults
skim_with_defaults()
skim(faithful)
}
