% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/skim_with.R
\name{skim_with}
\alias{skim_with}
\title{Set or add the summary functions for a particular type of data}
\usage{
skim_with(
  ...,
  base = sfl(n_missing = n_missing, complete_rate = complete_rate),
  append = TRUE
)
}
\arguments{
\item{...}{One or more (\code{sfl}) \code{skimmer_function_list} objects, with an
argument name that matches a particular data type.}

\item{base}{An \code{sfl} that sets skimmers for all column types.}

\item{append}{Whether the provided options should be in addition to the
defaults already in \code{skim}. Default is \code{TRUE}.}
}
\value{
A new \code{skim()} function. This is callable. See \code{\link[=skim]{skim()}} for
more details.
}
\description{
While skim is designed around having an opinionated set of defaults, you
can use this function to change the summary statistics that it returns.
}
\details{
\code{skim_with()} is a closure: a function that returns a new function. This
lets you have several skimming functions in a single R session, but it
also means that you need to assign the return of \code{skim_with()} before
you can use it.

You assign values within \code{skim_with} by using the \code{\link[=sfl]{sfl()}} helper (\code{skimr}
function list). This helper behaves mostly like \code{\link[dplyr:funs]{dplyr::funs()}}, but lets
you also identify which skimming functions you want to remove, by setting
them to \code{NULL}. Assign an \code{sfl} to each column type that you wish to modify.
Functions that summarize all data types, and always return the same type
of value, can be assigned to the \code{base} argument. The default base skimmers
compute the number of missing values \code{n_missing} and the rate of values being
complete, i.e. not missing.

When \code{append = TRUE} and local skimmers have names matching the names of
entries in the default \code{skim_function_list}, the values in the default list
are overwritten. Similarly, if \code{NULL} values are passed within \code{sfl()}, these
default skimmers are dropped. Otherwise, if \code{append = FALSE}, only the
locally-provided skimming functions are used.
}
\examples{
# Use new functions for numeric functions. If you don't provide a name,
# one will be automatically generated.
my_skim <- skim_with(numeric = sfl(median, mad), append = FALSE)
my_skim(faithful)

# If you want to remove a particular skimmer, set it to NULL
# This removes the inline histogram
my_skim <- skim_with(numeric = sfl(hist = NULL))
my_skim(faithful)

# This works with multiple skimmers. Just match names to overwrite
my_skim <- skim_with(numeric = sfl(iqr = IQR, p25 = NULL, p75 = NULL))
my_skim(faithful)

# Alternatively, set `append = FALSE` to replace the skimmers of a type.
my_skim <- skim_with(numeric = sfl(mean = mean, sd = sd), append = FALSE)

# Skimmers are unary functions. Partially apply arguments during assigment.
# For example, you might want to remove NA values.
my_skim <- skim_with(numeric = sfl(iqr = ~ IQR(., na.rm = TRUE)))

# Set multiple types of skimmers simultaneously.
my_skim <- skim_with(numeric = sfl(mean), character = sfl(length))

# Or pass the same as a list, unquoting the input.
my_skimmers <- list(numeric = sfl(mean), character = sfl(length))
my_skim <- skim_with(!!!my_skimmers)
}
