% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{mixSim}
\alias{mixSim}
\title{Simulate user tracked menstrual cycle data for an individual using the mixture model.}
\usage{
mixSim(i, skipProb, maxCycles, trueBetas, trueGammas, overlap)
}
\arguments{
\item{i}{Individual identifier. Character, numeric, or integer.}

\item{skipProb}{Vector of probabilities for the number of true cycles per tracked cycle. For
example, (.7, .2, .1) means that 70\% of observed cycles will contain one true cycle, 20\%
will contain 2 true cycles, and 10\% will contain 3 true cycles.}

\item{maxCycles}{Maximum number of true cycles per tracked cycle.}

\item{trueBetas}{Optional. True values for generated mean regression coefficients.}

\item{trueGammas}{Optional. True values for the generated precision regression coefficients.}

\item{overlap}{Optional. Number of (non-intercept) columns shared between X and Z. Columns are shared from left to right.}
}
\value{
\describe{
\item{'Individual'}{Individual identifiers.}
\item{'TrackedCycles'}{Tracked cycles.}
\item{'NumTrue'}{Number of true values.}
\item{'Mean'}{Individual's mean values.}
\item{'Beta0'}{Beta0 true value.}
\item{'Gamma0'}{Gamma0 true value.}
\item{'X0',...,'XN'}{Covariate matrix for Mean, where N is the length of trueBetas.}
\item{'Z0',...,'ZM'}{Covariate matrix for precision, where M is the length of trueGammas.}
}
}
\description{
This function generates synthetic data for user tracked menstrual cycles for a
single individual using the mixture model. For this model Beta_0 is set to log(30) and Gamma_0
is set to 15, although for the skipTrack model this lacks interpretation.
}
\seealso{
\code{\link{skipTrack.simulate}}
}
