% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{summary.skipTrack.model}
\alias{summary.skipTrack.model}
\title{Report skipTrack.model results to console}
\usage{
\method{summary}{skipTrack.model}(object, ...)
}
\arguments{
\item{object}{skipTrack.model object from the function skipTrack.fit}

\item{...}{arguments passed to skipTrack.results}
}
\value{
Invisible skipTrack.results. Prints info about skipTrack.model object
}
\description{
Report skipTrack.model results to console
}
\examples{
#Simulated data
simDat <- skipTrack.simulate(n = 100, skipProb = c(.7, .2, .1))

#Run model fit (should typically run with much more than 50 reps)
modFit <- skipTrack.fit(Y = simDat$Y, cluster = simDat$cluster, chains = 2, reps = 50)
summary(modFit, burnIn = 25) #Recommended burnIn with real data is at least 750


}
