% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_design.R,
%   R/normalize_numeric_runmatrix.R
\name{normalize_design}
\alias{normalize_design}
\title{Normalize Design}
\usage{
normalize_design(design, augmented = NULL)

normalize_design(design, augmented = NULL)
}
\arguments{
\item{design}{The design matrix.}

\item{augmented}{Default `NULL`. If}
}
\value{
Normalized design matrix

Normalized run matrix
}
\description{
Normalizes the numeric columns in the design to -1 to 1. This is important to do if your model has interaction or polynomial terms,
as these terms can introduce multi-collinearity and standardizing the numeric columns can reduce this problem.

Normalizes the numeric columns in the design to -1 to 1. This is important to do if your model has interaction or polynomial terms,
as these terms can introduce multi-collinearity and standardizing the numeric columns can reduce this problem.
}
\examples{
#Normalize a design
if(skpr:::run_documentation()) {
cand_set = expand.grid(temp = c(100,300,500),
                      altitude = c(10000,20000),
                      offset = seq(-10,-5,by=1),
                      type = c("A","B", "C"))
design = gen_design(cand_set, ~., 24)

#Un-normalized design
design
}
if(skpr:::run_documentation()) {
#Normalized design
normalize_design(design)
}
}
\keyword{internal}
