% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_db1b.R
\name{import_db1b}
\alias{import_db1b}
\title{Import Data from DB1B files}
\usage{
import_db1b(c, t, zip = FALSE, auto = TRUE)
}
\arguments{
\item{c}{Coupon csv file to be imported, in case of DB1B database}

\item{t}{Ticket csv file to be imported, in case of DB1B database}

\item{zip}{Should equal TRUE if original file comes from the BTS prezipped option.}

\item{auto}{Automatically assigns object}
}
\description{
Imports data from BTS/RITA/Transtats files
}
\details{
Coupon files can be found at \url{https://www.transtats.bts.gov/Fields.asp?gnoyr_VQ=FLM}.
Ticket files can be found at \url{https://www.transtats.bts.gov/Fields.asp?gnoyr_VQ=FKF}.
Both files should belong to the same year and same quarter.
\strong{Note}: We do recommend sparklyr to be used for larger sets of data.
More information on variables to select and type of files to use can be found \href{https://github.com/ropensci/skynet}{here}
}
\examples{
\dontrun{

import_db1b(skynet_example("Coupon_2001Q1.csv"), skynet_example("Ticket_2001Q1.csv"))

}
}
