% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{spatial.equinox}
\alias{spatial.equinox}
\title{Declination of the spatial equinox for a given location}
\usage{
spatial.equinox(hor, parallax = 0.00224)
}
\arguments{
\item{hor}{This should be a \emph{skyscapeR.horizon} object.}

\item{parallax}{(Optional) Average parallax value for the sun.
Defaults to 0.00224.}
}
\description{
Declination of the spatial equinox for a given location
}
\examples{
\dontrun{
hor <- createHWT(34.174051531543405, 110.81299818694872, name='Xipo, Lingbao')
spatial.equinox(hor)
}
}
\seealso{
\code{\link{jS}}, \code{\link{dS}}, \code{\link{eq}},
\code{\link{zenith}}, \code{\link{antizenith}}, \code{\link{parallax.corr}}
}
