% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{star.phases}
\alias{star.phases}
\title{Calculate the seasons and phase type of a star}
\usage{
star.phases(
  star,
  year,
  loc,
  alt.hor = 0,
  k = 0.2,
  limit = 6,
  alt.rs = 10,
  res = 1/24/6,
  refraction,
  atm,
  temp
)
}
\arguments{
\item{star}{Either the star name or a \emph{skyscapeR.star} object.}

\item{year}{The year of interest. Must be in the \emph{swephR} range of 13201 cal BC to 17191 AD}

\item{loc}{Location, either a \emph{skyscapeR.object} or a vector
containing the latitude and longitude of location, in this order.}

\item{alt.hor}{(Optional) The altitude of the horizon to consider.
Defaults to zero degrees.}

\item{k}{(Optional) Extinction coefficient (see Schaefer 1989).
Defaults to 0.2, corresponding to a poor night on mountain top
or best night at a dry sea level site.}

\item{limit}{(Optional) The maximum magnitude of a star that can be
visible with the naked eye. Defaults to 6.}

\item{alt.rs}{(Optional) The maximum altitude of a star's first or last
visibility for it to still be considered to be as rising or setting.
Defaults to ten degrees.}

\item{res}{(Optional) Resolution of calculation. The smaller this
figure the slower the computation. Defaults to 1/24/6, i.e. every 10 minutes.}

\item{refraction}{(Optional) Whether atmospheric refraction is to be taken into account.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{atm}{(Optional) Atmospheric pressure for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}

\item{temp}{(Optional) Atmospheric temperature for refraction calculation.
If not given the value set by \code{\link{skyscapeR.vars}} will be used instead.}
}
\description{
This function calculates the seasons (Rising, Setting, etc.)
and phase types (Arising and Lying Hidden, Curtailed Passage) of a
star for a given location and epoch. This functions uses the
\emph{arcus visionis} approximation of Purrington (1988) and
the atmospheric extinction approximation of Schaefer (1989). For
the nomenclature used, and description of star phase types, see Brady (2015).
}
\examples{
\dontrun{
ss1 <- star.phases('Aldebaran',-4000, c(35,-8,200))

# One can then look at the star's phase type:
ss1$metadata$type

# Date range of seasons:
ss1$metadata$seasons

# Date range of phase-type events:
ss1$metadata$events

# And plot them:
plot(ss1)

# You can play with the parameters and see how predictions change:
ss1 <- star.phases('Aldebaran',-4000, c(35,-8,200), alt.hor=2, alt.rs=5)
plot(ss1)
}
}
\references{
Purrington, Robert D. (1988) Heliacal Rising and Setting:
Quantitative Aspects, \emph{Journal for the History of Astronomy
(Archaeoastronomy Supplement 12)} 19, S72-S84. Available online at
[SAO/NASA ADS Astronomy Abstract Service](http://adsabs.harvard.edu/abs/1988JHAS...19...72P)

Brady, Bernadette (2015) Star Phases: the Naked-eye Astronomy of the Old Kingdom
Pyramid Texts. In F Silva and N Campion (eds) \emph{Skyscapes: The Role and Importance of
the Sky in Archaeology}. Oxford: Oxbow Books, pp. 76-86.
}
\seealso{
\code{\link{plot.skyscapeR.starphases}}
}
