% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slackr_setup.r, R/zcamels.r
\name{slackr_setup}
\alias{slackrSetup}
\alias{slackr_setup}
\title{Setup environment variables for Slack API access}
\usage{
slackr_setup(channel = "#general", username = "slackr", icon_emoji = "",
  incoming_webhook_url = "", api_token = "", config_file = "~/.slackr",
  echo = FALSE)

slackrSetup(channel = "#general", username = "slackr", icon_emoji = "",
  incoming_webhook_url = "", api_token = "", config_file = "~/.slackr",
  echo = FALSE)
}
\arguments{
\item{channel}{default channel to send the output to (chr) defaults to \code{#general}}

\item{username}{the username output will appear from (chr) defaults to \code{slackr}}

\item{icon_emoji}{which emoji picture to use (chr) defaults to none (can be
left blank in config file as well)}

\item{incoming_webhook_url}{the slack.com URL prefix to use (chr) defaults to none}

\item{api_token}{the Slack full API token (chr)}

\item{config_file}{a configuration file (DCF) - see \link{read.dcf} - format
with the config values.}

\item{echo}{display the configuration variables (bool) initially \code{FALSE}}
}
\description{
Initialize all the environment variables \code{\link{slackr}} will need to use to
work properly.
}
\details{
By default, \code{\link{slackr}} (and other functions) will use the \code{#general}
room and a username of \code{slackr()} with no emoji.

If a valid file is found at the locaiton pointed to by \code{config_file}, the
values there will be used. The fields should be specified as such in the file:

\preformatted{
 api_token: YOUR_FULL_API_TOKEN
 channel: #general
 username: slackr
 incoming_webhook_url: https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX
}
}
\note{
You need a \href{slack.com}{Slack} account and all your API URLs & tokens setup
      to use this package.
}
\examples{
\dontrun{
# reads from default file (i.e. ~/.slackr)
slackr_setup()

# reads from alternate config
slackr_setup(config_file="/path/to/my/slackrconfig)

# the hard way
slackr_setup(channel="#code",
            incoming_webhook_url="https://hooks.slack.com/services/XXXXX/XXXXX/XXXXX")
}
}
\seealso{
\code{\link{slackr}}, \code{\link{dev_slackr}}, \code{\link{save_slackr}},
         \code{\link{slackr_upload}}
}

