% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slanter.R
\name{oclust}
\alias{oclust}
\title{Hierarchically cluster ordered data.}
\usage{
oclust(distances, method = "ward.D2", order = NULL, members = NULL)
}
\arguments{
\item{distances}{A distances object (as created by \code{stats::dist}).}

\item{method}{The clustering method to use (only \code{ward.D} and \code{ward.D2} are supported).}

\item{order}{If specified, assume the data will be re-ordered by this order.}

\item{members}{Optionally, the number of members for each row/column of the distances (by default, one each).}
}
\value{
A clustering object (as created by \code{hclust}).
}
\description{
Given a distance matrix for sorted objects, compute a hierarchical clustering preserving this
order. That is, this is similar to \code{hclust} with the constraint that the result's order is
always \code{1:N}.
}
\details{
If an \code{order} is specified, assumes that the data will be re-ordered by this order. That is,
the indices in the returned \code{hclust} object will refer to the post-reorder data locations,
**not** to the current data locations.

This can be applied to the results of \code{slanted_reorder}, to give a "plausible"
clustering for the data.
}
\examples{
clusters <- slanter::oclust(dist(mtcars), order=1:dim(mtcars)[1])
clusters$order
}
