% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slanter.R
\name{sheatmap}
\alias{sheatmap}
\title{Plot a heatmap with values as close to the diagonal as possible.}
\usage{
sheatmap(data, ..., order_data = NULL, annotation_col = NULL,
  annotation_row = NULL, order_rows = TRUE, order_cols = TRUE,
  squared_order = TRUE, same_order = FALSE, cluster_rows = TRUE,
  cluster_cols = TRUE, oclust_rows = TRUE, oclust_cols = TRUE,
  clustering_distance_rows = "euclidian",
  clustering_distance_cols = "euclidian",
  clustering_method = "ward.D2", clustering_callback = NA)
}
\arguments{
\item{data}{A rectangular matrix to plot, of non-negative values (unless \code{order_data} is specified).}

\item{...}{Additional flags to pass to \code{pheatmap}.}

\item{order_data}{An optional matrix of non-negative values of the same size to use for computing the orders.}

\item{annotation_col}{Optional data frame describing each column.}

\item{annotation_row}{Optional data frame describing each row.}

\item{order_rows}{Whether to reorder the rows. Otherwise, use the current order.}

\item{order_cols}{Whether to reorder the columns. Otherwise, use the current order.}

\item{squared_order}{Whether to reorder to minimize the l2 norm (otherwise minimizes the l1 norm).}

\item{same_order}{Whether to apply the same order to both rows and columns (if reordering both).}

\item{cluster_rows}{Whether to cluster the rows, or the clustering to use.}

\item{cluster_cols}{Whether to cluster the columns, or the clustering to use.}

\item{oclust_rows}{Whether to use \code{oclust} instead of \code{hclust} for the rows (if
clustering them).}

\item{oclust_cols}{Whether to use \code{oclust} instead of \code{hclust} for the columns (if
clustering them).}

\item{clustering_distance_rows}{The default method for computing row distances (by default,
\code{euclidian}).}

\item{clustering_distance_cols}{The default method for computing column distances (by default,
\code{euclidian}).}

\item{clustering_method}{The default method to use for hierarchical clustering (by default,
\code{ward.D2} and *not* \code{complete}).}

\item{clustering_callback}{Is not supported.}
}
\value{
Whatever \code{pheatmap} returns.
}
\description{
Given a matrix expressing the cross-similarity between two (possibly different) sets of entities,
this will reorder it to move the high values close to the diagonal, for a better visualization.
}
\details{
If you have an a-priori order for the rows and/or columns, you can prevent reordering either or
both by specifying \code{order_rows=FALSE} and/or \code{order_cols=FALSE}. Otherwise,
\code{slanted_orders} is used to compute the "ideal" slanted order for the data.

By default, the rows and columns are ordered independently from each other. If the matrix is
asymmetric but square (e.g., a matrix of weights of a directed graph such as a
K-nearest-neighbors graph), then you can can specify \code{same_order=TRUE} to force both rows and
columns to the same order.

There are four options for controlling clustering:

* By default, \code{sheatmap} will generate a clustering tree using \code{oclust}, to generate
  the "best" clustering that is also compatible with the slanted order.

* Request that \code{sheatmap} will use the same \code{hclust} as
  \code{pheatmap} (e.g., \code{oclust_rows=FALSE}). In this case, the tree is reordered to
  be the "most compatible" with the target slanted order. That is, \code{sheatmap} will invoke
  \code{reorder_hclust} so that, for each node of the tree, the order of the two sub-trees will
  be chosen to best match the target slanted order. The end result need not be identical to the
  slanted order, but is as close as possible given the \code{hclust} clustering tree.

* Specify an explicit clustering (e.g., \code{cluster_rows=hclust(...)}). In this case,
  \code{sheatmap} will again merely reorder the tree but will not modify it.

In addition, you can give this function any of the \code{pheatmap} flags, and it will just pass
them on. This allows full control over the diagram's features.

Note that \code{clustering_callback} is not supported. In addition, the default
\code{clustering_method} here is \code{ward.D2} instead of \code{complete}, since the only
methods supported by \code{oclust} are \code{ward.D} and \code{ward.D2}.
}
\examples{
slanter::sheatmap(cor(t(mtcars)))
slanter::sheatmap(cor(t(mtcars)), oclust_rows=FALSE, oclust_cols=FALSE)
pheatmap::pheatmap(cor(t(mtcars)))
}
